// This file was generated by generate_feature_manifest.py from FeatureManifest.yaml. DO NOT EDIT.
export const FeatureManifest = {"no-feature-firefox-desktop": {"description": "A dummy feature for experiments that target no feature.", "owner": "beth@mozilla.com", "applications": ["firefox-desktop", "firefox-desktop-background-task"], "hasExposure": false, "variables": {}}, "testFeature": {"description": "Test only feature", "owner": "beth@mozilla.com", "applications": ["firefox-desktop", "firefox-desktop-background-task"], "hasExposure": false, "isEarlyStartup": true, "variables": {"enabled": {"type": "boolean", "description": "Whether or not this feature is enabled"}, "testInt": {"type": "int", "fallbackPref": "nimbus.testing.testInt", "description": "Int pref used by platform API tests"}, "testSetString": {"type": "string", "setPref": {"branch": "user", "pref": "nimbus.testing.testSetString"}, "description": "A string pref set by Nimbus tests"}}}, "nimbus-qa-1": {"description": "A feature for testing pref-setting on the default branch.", "owner": "beth@mozilla.com", "hasExposure": false, "variables": {"value": {"type": "string", "setPref": {"branch": "default", "pref": "nimbus.qa.pref-1"}, "description": "The value to set for the pref."}}}, "nimbus-qa-2": {"description": "A feature for testing pref-setting on the user branch.", "owner": "beth@mozilla.com", "hasExposure": false, "variables": {"value": {"type": "string", "setPref": {"branch": "user", "pref": "nimbus.qa.pref-2"}, "description": "The value to set for the pref."}}}, "prefFlips": {"description": "Flip arbitrary prefs. Controlled by release management.", "owner": "beth@mozilla.com", "hasExposure": false, "variables": {"prefs": {"type": "json", "description": "The prefs to set."}}, "schema": {"uri": "resource://nimbus/schemas/PrefFlipsFeature.schema.json", "path": "toolkit/components/nimbus/schemas/PrefFlipsFeature.schema.json"}}, "search": {"description": "Search engine experimentation support and testing features.", "owner": "search-and-suggest-program@mozilla.com", "hasExposure": false, "variables": {"extraParams": {"type": "json", "description": "This allows extra parameters to be set for search engines requests including, where calls to the suggestions API, the search engine configuration defines those parameters.\nThe use of this field should be coordinated with the Search team.\nThe field value is an array of objects with key/value fields. For example:\n[\n  {\"key\": \"google_channel_row\", \"value\": \"foo\"}\n]\nThis is matched to a section in the search configuration:\n\"extraParams\": [\n  {\n    \"name\": \"channel\",\n    \"pref\": \"google_channel_row\",\n    \"condition\": \"pref\"\n  }\n],\nIn this case, the resulting URL for the appropriate search engine would have `&channel=foo` added to the URL when doing searches.\nIf the key is not referenced in the search configuration, then no parameter will be added. Only the search team can update the configuration."}, "logEnabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.search.log"}, "description": "Whether or not enable search log in their console."}, "richSuggestionsFeatureGate": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.urlbar.richSuggestions.featureGate"}, "description": "Feature gate that controls whether Rich Suggestions are enabled."}, "scotchBonnetEnableOverride": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.urlbar.scotchBonnet.enableOverride"}, "description": "Whether or not enabling scotch bonnet feature. If this variable is true, the following features are available as default. * Unified search button * Secondary action buttons * Search term persistence * Intuitive search keywords * HTTP swap"}, "serpEventTelemetryCategorizationEnabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.search.serpEventTelemetryCategorization.enabled"}, "description": "Whether the Glean SERP event telemetry for SERP categorization is enabled."}, "trendingEnabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.urlbar.trending.featureGate"}, "description": "Feature gate that controls whether trending suggestions are enabled."}, "trendingRequireSearchMode": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.urlbar.trending.requireSearchMode"}, "description": "Controls whether trending suggestions are only shown in search mode or not."}, "trendingMaxResultsNoSearchMode": {"type": "int", "setPref": {"branch": "default", "pref": "browser.urlbar.trending.maxResultsNoSearchMode"}, "description": "The maximum number of trending results mode outside search mode."}, "newSearchConfigEnabled": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.search.newSearchConfig.enabled"}, "description": "Whether search-config-v2 is enabled for the user. This will only take effect when the user restarts. Obsolete. This is kept until all multi-feature roll-outs using it are ended to prevent un-enrollment."}, "targetExperiment": {"type": "string", "description": "The slug of the experiment someone is requesting enrollment and branch information for. (Note that the featureId needs to be set to \"search\".)"}}}, "searchConfiguration": {"description": "Search experimentation support for the engine configuration", "owner": "search-and-suggest-program@mozilla.com", "isEarlyStartup": true, "hasExposure": false, "variables": {"experiment": {"type": "string", "fallbackPref": "browser.search.experiment", "description": "Used to activate only matching configurations that contain the value in `experiment`"}, "seperatePrivateDefaultUIEnabled": {"type": "boolean", "description": "Whether the UI for the separate private default feature is enabled."}, "seperatePrivateDefaultUrlbarResultEnabled": {"type": "boolean", "description": "Whether the urlbar result for the separate private default is shown."}}}, "urlbar": {"description": "The Address Bar", "owner": "search-and-suggest-program@mozilla.com", "hasExposure": true, "exposureDescription": "The timing of the exposure event depends on the experiment, but generally the event is recorded once per app session when the user first encounters the UI of the experiment in which they're enrolled.", "variables": {"addonsFeatureGate": {"type": "boolean", "fallbackPref": "browser.urlbar.addons.featureGate", "description": "Feature gate that controls whether all aspects of the addons suggestion feature are exposed to the user."}, "addonsShowLessFrequentlyCap": {"type": "int", "description": "If defined and non-zero, this is the maximum number of times the user will be able to click the \"Show less frequently\" command for addon suggestions. If undefined or zero, the user will be able to click the command without any limit."}, "autoFillAdaptiveHistoryEnabled": {"type": "boolean", "fallbackPref": "browser.urlbar.autoFill.adaptiveHistory.enabled", "description": "Whether enabling adaptive history autofill."}, "autoFillAdaptiveHistoryMinCharsThreshold": {"type": "int", "fallbackPref": "browser.urlbar.autoFill.adaptiveHistory.minCharsThreshold", "description": "Minimum char length of the user's search string to trigger adaptive history autofill."}, "autoFillAdaptiveHistoryUseCountThreshold": {"type": "string", "description": "This value assumes float expression like \"0.47\". Threshold for use count of input history that we handle as adaptive history autofill. If the use count is this value or more, it will be a candidate."}, "fakespotFeatureGate": {"type": "boolean", "fallbackPref": "browser.urlbar.fakespot.featureGate", "description": "Feature gate that controls whether all aspects of the Fakespot suggestion feature are exposed to the user."}, "fakespotMinKeywordLength": {"type": "int", "description": "The minimum prefix length of a Fakespot keyword the user must type to trigger the suggestion."}, "fakespotShowLessFrequentlyCap": {"type": "int", "fallbackPref": "browser.urlbar.fakespot.showLessFrequentlyCap", "description": "If defined and non-zero, this is the maximum number of times the user will be able to click the \"Show less frequently\" command for Fakespot suggestions. If undefined or zero, the user will be able to click the command without any limit."}, "fakespotSuggestedIndex": {"type": "int", "fallbackPref": "browser.urlbar.fakespot.suggestedIndex", "description": "The index of Fakespot results within the Firefox Suggest section. A negative index is relative to the end of the section."}, "keywordExposureResults": {"type": "string", "setPref": {"pref": "browser.urlbar.keywordExposureResults", "branch": "user"}, "description": "Comma-separated list of result types that should trigger keyword-exposure telemetry. Keyword exposures can be recorded along with result exposures. To enable keyword exposures for a result type, you must add it both to this variable and to `exposureResults`. The only exception is the \"rust_exposure\" result type, which can be added to this variable even if it's not in `exposureResults` since it's enabled by setting the `quickSuggestExposureSuggestionTypes` variable. Keyword exposures are recorded in the `urlbar-keyword-exposure` ping. See that ping's description for more."}, "mdnFeatureGate": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.urlbar.mdn.featureGate"}, "description": "Feature gate that controls whether all aspects of the mdn suggestion feature are exposed to the user."}, "merinoClientVariants": {"type": "string", "fallbackPref": "browser.urlbar.merino.clientVariants", "description": "Comma separated list of client variants to report to the Merino server. May impact server behavior."}, "merinoEndpointURL": {"type": "string", "fallbackPref": "browser.urlbar.merino.endpointURL", "description": "The Merino endpoint URL, not including parameters. An empty string will cause Firefox not to fetch from Merino."}, "merinoProviders": {"type": "string", "fallbackPref": "browser.urlbar.merino.providers", "description": "Comma-separated list of providers to request from the Merino server. Merino will return suggestions only for these providers."}, "merinoTimeoutMs": {"type": "int", "fallbackPref": "browser.urlbar.merino.timeoutMs", "description": "Timeout for Merino fetches (ms)"}, "exposureResults": {"type": "string", "setPref": {"pref": "browser.urlbar.exposureResults", "branch": "user"}, "description": "Comma-separated list of result types that should trigger exposure telemetry, which is recorded in the `exposure` event. By default exposure results are visible like usual, but they can be hidden by setting the `showExposureResults` variable to false. To also record keyword exposures for a result type, include it in the `keywordExposureResults` variable as well."}, "showExposureResults": {"type": "boolean", "setPref": {"pref": "browser.urlbar.showExposureResults", "branch": "user"}, "description": "Boolean used to determine if the results defined in `exposureResults` should be shown in search results. Should be false for Control branch of an experiment."}, "pocketFeatureGate": {"type": "boolean", "fallbackPref": "browser.urlbar.pocket.featureGate", "description": "Feature gate that controls whether all aspects of the Pocket suggestions feature are exposed to the user."}, "pocketShowLessFrequentlyCap": {"type": "int", "description": "If defined and non-zero, this is the maximum number of times the user will be able to click the \"Show less frequently\" command for Pocket suggestions. If undefined or zero, the user will be able to click the command without any limit."}, "pocketSuggestIndex": {"type": "int", "description": "The group-relative suggestedIndex of Pocket suggestions within the Firefox Suggest section."}, "quickSuggestAllowPositionInSuggestions": {"type": "boolean", "fallbackPref": "browser.urlbar.quicksuggest.allowPositionInSuggestions", "description": "Whether quick suggest results can be shown in position specified in the suggestions."}, "quickSuggestAmpTopPickCharThreshold": {"type": "int", "fallbackPref": "browser.urlbar.quicksuggest.ampTopPickCharThreshold", "description": "Character-count threshold (inclusive) for showing AMP suggestions as top picks. If an AMP suggestion is triggered by a keyword at least this many characters long, it will be shown as a top pick. When this variable is set, full keywords will also show AMP suggestions as top picks even if they have fewer characters than this threshold."}, "quickSuggestContextualOptInEnabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.urlbar.quicksuggest.contextualOptIn"}, "description": "Whether the Firefox Suggest contextual opt-in result is enabled. If true, this implicitly disables shouldShowOnboardingDialog."}, "quickSuggestContextualOptInSayHello": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.urlbar.quicksuggest.contextualOptIn.sayHello"}, "description": "Controls which variant of the copy is used for the Firefox Suggest contextual opt-in result."}, "quickSuggestContextualOptInTopPosition": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.urlbar.quicksuggest.contextualOptIn.topPosition"}, "description": "Controls whether the Firefox Suggest contextual opt-in result appears at the top of results or at the bottom, after one-off buttons."}, "quickSuggestDataCollectionEnabled": {"type": "boolean", "description": "Whether data collection should be enabled by default. If this variable is specified, it will override the value implied by the scenario. It will never override the user's local preference to disable (or enable) data collection, if the user has already toggled that preference."}, "quickSuggestEnabled": {"type": "boolean", "fallbackPref": "browser.urlbar.quicksuggest.enabled", "description": "Gate for the Firefox Suggest feature as a whole. If false, the Firefox Suggest preferences UI and Suggest suggestions will not be shown. If true, the preferences UI will be shown, and the user can turn suggestions on or off."}, "quickSuggestExposureSuggestionTypes": {"type": "string", "setPref": {"pref": "browser.urlbar.quicksuggest.exposureSuggestionTypes", "branch": "user"}, "description": "Comma-separated list of Suggest exposure suggestion types to enable. Exposure suggestions are used to test potential exposures. They trigger exposure telemetry based on a set of keywords you provide but they are never visible. Set this variable to the `suggestion_type` defined in the remote settings record(s) that contains your keywords. If you want to test multiple suggestion types, separate them with commas, but also consider using one experiment branch per type, especially if you are also enabling keyword exposures. Exposure suggestions are recorded in telemetry with the \"rust_exposure\" result type. It's not necessary to include \"rust_exposure\" in `exposureResults`. Unless you are testing other results in the same experiment branch, it's also not necessary to set `showExposureResults: false`. To also record keyword exposures, include \"rust_exposure\" in `keywordExposureResults`."}, "quickSuggestHideSettingsUI": {"type": "boolean", "fallbackPref": "browser.urlbar.quicksuggest.hideSettingsUI", "description": "This variable is intended to be used in potential exposure experiments in regions and locales where Suggest normally isn't enabled. Potential exposure suggestions are implemented in Suggest, and this variable lets us enable core Suggest functionality but keep it hidden. Set both `quickSuggestEnabled` and `quickSuggestHideSettingsUI` to true, along with `quickSuggestExposureSuggestionTypes`. This variable does NOT hide visible suggestions and other UI that can be independently enabled with other Nimbus variables. But since all visible suggestions are disabled by default for users not in the Suggest population, as long as you don't set any Nimbus variables to enable other suggestions and UI, Suggest will remain hidden."}, "quickSuggestImpressionCapsSponsoredEnabled": {"type": "boolean", "fallbackPref": "browser.urlbar.quicksuggest.impressionCaps.sponsoredEnabled", "description": "Whether sponsored suggestions are subject to impression frequency caps. If false, sponsored suggestions can be shown an unlimited number of times over any given period. If true, sponsored suggestion impressions will be subject to the caps in the remote settings configuration."}, "quickSuggestImpressionCapsNonSponsoredEnabled": {"type": "boolean", "fallbackPref": "browser.urlbar.quicksuggest.impressionCaps.nonSponsoredEnabled", "description": "Whether non-sponsored suggestions are subject to impression frequency caps. If false, non-sponsored suggestions can be shown an unlimited number of times over any given period. If true, non-sponsored suggestion impressions will be subject to the caps in the remote settings configuration."}, "quickSuggestMlEnabled": {"type": "boolean", "fallbackPref": "browser.urlbar.quicksuggest.mlEnabled", "description": "Whether Suggest will use the ML backend in addition to Rust."}, "quickSuggestNonSponsoredEnabled": {"type": "boolean", "description": "Whether non-sponsored suggestions should be enabled by default. If this variable is specified, it will override the value implied by the scenario. It will never override the user's local preference to disable (or enable) non-sponsored suggestions, if the user has already toggled that preference."}, "quickSuggestNonSponsoredIndex": {"type": "int", "fallbackPref": "browser.urlbar.quicksuggest.nonSponsoredIndex", "description": "The index of non-sponsored QuickSuggest results within the general group. A negative index is relative to the end of the group"}, "quickSuggestOnboardingDialogVariation": {"type": "string", "description": "Specify the messages/UI variation for QuickSuggest onboarding dialog. This value is case insensitive."}, "quickSuggestRankingMode": {"type": "string", "fallbackPref": "browser.urlbar.quicksuggest.rankingMode", "description": "Specify the ranking mode for QuickSuggest.\n  - \"default\": ranking by static scores specified by individual providers.\n  - \"interest\": ranking by relevance scores provided by `ContentRelevancyManager`.\n  - \"random\": ranking by randomly selecting a winner out of candidates.\nNote that this ranking mode can still be overridden by `quickSuggestScoreMap`. If the ranking mode is unspecified or set to any unknown values, it will default to the static score based ranking.", "enum": ["default", "interest", "random"]}, "quickSuggestScenario": {"type": "string", "description": "The Firefox Suggest scenario in which the user is enrolled", "enum": ["history", "offline", "online"]}, "quickSuggestScoreMap": {"type": "json", "description": "A JSON object that maps telemetry result types to suggestion scores. If a telemetry result type is present in this map, the client will use the corresponding score as the score for all suggestions of the type, overriding all other sources of scores for the type. In other words, the scores in this map will override scores that are set in remote settings and Merino as well as scores that are hardcoded in the client. Example entries: `\"amo\": 0.5`, `\"adm_sponsored\": 0.9`"}, "quickSuggestShouldShowOnboardingDialog": {"type": "boolean", "fallbackPref": "browser.urlbar.quicksuggest.shouldShowOnboardingDialog", "description": "Whether or not to show the QuickSuggest onboarding dialog"}, "quickSuggestShowOnboardingDialogAfterNRestarts": {"type": "int", "fallbackPref": "browser.urlbar.quicksuggest.showOnboardingDialogAfterNRestarts", "description": "Show QuickSuggest onboarding dialog after N browser restarts"}, "quickSuggestSponsoredEnabled": {"type": "boolean", "description": "Whether sponsored suggestions should be enabled by default. If this variable is specified, it will override the value implied by the scenario. It will never override the user's local preference to disable (or enable) sponsored suggestions, if the user has already toggled that preference."}, "quickSuggestSponsoredIndex": {"type": "int", "fallbackPref": "browser.urlbar.quicksuggest.sponsoredIndex", "description": "The index of sponsored Firefox Suggest results within the Firefox Suggest section when \"Show search suggestions ahead of browsing history in address bar results\" is checked. When not checked, the index is hardcoded as -1. Negative indexes are relative to the end of the section."}, "quickSuggestSponsoredPriority": {"type": "boolean", "fallbackPref": "browser.urlbar.quicksuggest.sponsoredPriority", "description": "Whether or not showing sponsored suggestion as priority. If this variable is true, the following things are processed. * \"Sponsored\" label is shown as the group label. * Change the suggested index to 1. * Handle as top pick."}, "recentSearchesFeatureGate": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.urlbar.recentsearches.featureGate"}, "description": "Gate for the recent searches feature."}, "recentSearchesMaxResults": {"type": "int", "setPref": {"branch": "default", "pref": "browser.urlbar.recentsearches.maxResults"}, "description": "The maximum number of recent searches to show."}, "showSearchTermsFeatureGate": {"type": "boolean", "fallbackPref": "browser.urlbar.showSearchTerms.featureGate", "description": "Gate for the show search terms feature. If false, the preference#search will not show the search terms feature checkbox, and search terms will never persist in the urlbar. If true, the preference checkbox will be shown on preferences#search, and the user can choose to persist search terms on or off in the urlbar."}, "weatherFeatureGate": {"type": "boolean", "fallbackPref": "browser.urlbar.weather.featureGate", "description": "Feature gate that controls whether all aspects of the weather suggestion feature are exposed to the user."}, "weatherKeywordsMinimumLength": {"type": "int", "description": "If defined and non-zero, the weather suggestion will be triggered by typing any prefix of a full weather keyword when the prefix is at least `weatherKeywordsMinimumLength` characters long. If this variable is absent or zero, Firefox will fall back to the minimum length defined in remote settings. If neither Nimbus nor remote settings defines a minimum length, only full keywords will trigger the suggestion."}, "weatherShowLessFrequentlyCap": {"type": "int", "description": "If defined and non-zero, this is the maximum number of times the user will be able to click the \"Show less frequently\" command for weather suggestions. If undefined or zero, the user will be able to click the command without any limit."}, "weatherUiTreatment": {"type": "int", "fallbackPref": "browser.urlbar.weather.uiTreatment", "description": "The UI treatment to use for weather suggestions. Possible values: 0: (default) Simplest UI with current temperature and location 1: Simpler UI, adds current conditions, high/low, and URL 2: Full UI, adds forecast"}, "yelpMinKeywordLength": {"type": "int", "description": "The minimum prefix length of a Yelp keyword the user must type to trigger the suggestion."}, "yelpMlEnabled": {"type": "boolean", "fallbackPref": "browser.urlbar.yelp.mlEnabled", "description": "Whether Yelp suggestions will be served from the Suggest ML backend instead of Rust."}, "yelpFeatureGate": {"type": "boolean", "fallbackPref": "browser.urlbar.yelp.featureGate", "description": "Feature gate that controls whether all aspects of the Yelp suggestion feature are exposed to the user."}, "yelpShowLessFrequentlyCap": {"type": "int", "fallbackPref": "browser.urlbar.yelp.showLessFrequentlyCap", "description": "If defined and non-zero, this is the maximum number of times the user will be able to click the \"Show less frequently\" command for Yelp suggestions. If undefined or zero, the user will be able to click the command without any limit."}, "yelpSuggestNonPriorityIndex": {"type": "int", "description": "The group-relative suggestedIndex of Yelp suggestions within the Firefox Suggest section. Ignored when `yelpSuggestPriority` is true."}, "yelpSuggestPriority": {"type": "boolean", "fallbackPref": "browser.urlbar.yelp.priority", "description": "Whether or not showing yelp suggestion as priority. If this variable is true, the following things are processed. * Change the suggested index to 1. * Handle as top pick."}, "originsAlternativeEnable": {"description": "Use an alternative ranking algorithm for autofilling origins, that is mainly domains of Web pages. When the user types the beginning of an origin, we autofill the whole origin. Whether autofill happens depends on the ranking algorithm. Bookmarks are always autofilled anyway.", "type": "boolean", "setPref": {"branch": "user", "pref": "places.frecency.origins.alternative.featureGate"}}, "originsDaysCutOff": {"description": "The alternative ranking algorithm only considers pages visited in the last N days, where N is controlled by this variable.", "type": "int", "setPref": {"branch": "user", "pref": "places.frecency.origins.alternative.daysCutOff"}}, "pagesAlternativeEnable": {"description": "Use an alternative ranking algorithm for sorting history and bookmarks among the urlbar results.", "type": "boolean", "setPref": {"branch": "user", "pref": "places.frecency.pages.alternative.featureGate"}}, "pagesNumSampledVisits": {"description": "The number of recent visits to sample when calculating the ranking of a page. Examining all the visits would be expensive, so we only sample recent visits.", "type": "int", "setPref": {"branch": "user", "pref": "places.frecency.pages.alternative.numSampledVisits"}}, "pagesHalfLifeDays": {"description": "The number of days after which the ranking halves. This implements the \"recency\" part of the algorithm.", "type": "int", "setPref": {"branch": "user", "pref": "places.frecency.pages.alternative.halfLifeDays"}}, "pagesHighWeight": {"description": "The weight to use for the high importance bucket.", "type": "int", "setPref": {"branch": "user", "pref": "places.frecency.pages.alternative.highWeight"}}, "pagesMediumWeight": {"description": "The weight to use for the medium importance bucket.", "type": "int", "setPref": {"branch": "user", "pref": "places.frecency.pages.alternative.mediumWeight"}}, "pagesLowWeight": {"description": "The weight to use for the low importance bucket.", "type": "int", "setPref": {"branch": "user", "pref": "places.frecency.pages.alternative.lowWeight"}}}}, "aboutwelcome": {"description": "The about:welcome page", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent once per browsing session when the about:welcome URL is first accessed.", "isEarlyStartup": true, "variables": {"enabled": {"type": "boolean", "fallbackPref": "browser.aboutwelcome.enabled", "description": "Should users see about:welcome? If this is false, users will see a regular new tab instead."}, "id": {"type": "string", "description": "Descriptive ID for the about:welcome content"}, "screens": {"type": "json", "fallbackPref": "browser.aboutwelcome.screens", "description": "Content to show in the onboarding flow"}, "modalScreens": {"type": "json", "fallbackPref": "browser.aboutwelcome.modalScreens", "description": "Content to show in the onboarding modal, if different from that in the onboarding flow"}, "languageMismatchEnabled": {"type": "boolean", "fallbackPref": "intl.multilingual.aboutWelcome.languageMismatchEnabled", "description": "Suggest to change the language on about:welcome when there is a mismatch with the OS."}, "transitions": {"type": "boolean", "description": "Enable transition effect between screens"}, "showModal": {"type": "boolean", "fallbackPref": "browser.aboutwelcome.showModal", "description": "Should users see window modal onboarding"}, "requireAction": {"type": "boolean", "fallbackPref": "browser.aboutwelcome.requireAction", "description": "When showModal is enabled, should action be required to proceed (show as a window modal with dismiss using the ESC key disabled)"}, "backdrop": {"type": "string", "fallbackPref": "browser.aboutwelcome.backdrop", "description": "Specify the color to be used to update the background color"}, "toolbarButtonEnabled": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.aboutwelcome.toolbarButtonEnabled"}, "description": "Should the return to about:welcome toolbar button be shown"}}}, "moreFromMozilla": {"description": "New page on about:preferences to suggest more Mozilla products", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent once per browsing session when the about:preferences URL is first accessed.", "variables": {"enabled": {"type": "boolean", "fallbackPref": "browser.preferences.moreFromMozilla", "description": "Should users see the new more from Mozilla section."}, "template": {"type": "string", "fallbackPref": "browser.preferences.moreFromMozilla.template", "description": "UI template used to display Mozilla products. Possible values simple, advanced. Default is simple."}}}, "windowsLaunchOnLogin": {"description": "New checkbox in about:preferences startup section to start Firefox on Windows login", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent once per browsing session when the about:preferences URL is first accessed.", "variables": {"enabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.startup.windowsLaunchOnLogin.enabled"}, "description": "Should users see the Windows launch on login checkbox."}}}, "firefoxBridge": {"description": "Controls for Firefox Bridge extension and extension registration", "owner": "install-update@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.firefoxbridge.enabled"}, "description": "Should Firefox Bridge be registered within firefoxBridgeNativeMessaging startup idle task for use with native messaging proxy."}}}, "abouthomecache": {"description": "The startup about:home cache.", "owner": "omc@mozilla.com, mconley@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "boolean", "description": "Is the feature enabled?", "setPref": {"branch": "user", "pref": "browser.startup.homepage.abouthome_cache.enabled"}}}}, "newtab": {"description": "The about:newtab page", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent once per browsing session when the first newtab page loads (either about:newtab or about:home).", "isEarlyStartup": true, "variables": {"newTheme": {"type": "boolean", "description": "Enable the new theme"}, "customizationMenuEnabled": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.customizationMenu.enabled", "description": "Enable the customization panel inside of the newtab"}, "prefsButtonIcon": {"type": "string", "description": "Icon url to use for the preferences button"}, "topSitesContileEnabled": {"type": "boolean", "fallbackPref": "browser.topsites.contile.enabled", "description": "Enable the Contile integration for Sponsored Top Sites"}, "topSitesUseAdditionalTilesFromContile": {"type": "boolean", "description": "Allow Contile to use additonal sponsored top sites"}}}, "newtabUnifiedAds": {"description": "Mozilla Ad Routing Service (MARS) unified ads service", "owner": "mcrawford@mozilla.com, sdowne@mozilla.com", "hasExposure": false, "variables": {"unifiedAdsEndpoint": {"description": "The URL for the MARS API endpoint.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.unifiedAds.endpoint"}}, "unifiedAdsSpocsEnabled": {"type": "boolean", "description": "Enable MARS endpoint to serve ads for recommended stories", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.unifiedAds.spocs.enabled"}}, "unifiedAdsTilesEnabled": {"type": "boolean", "description": "Enable MARS endpoint to serve content for top sites tiles", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.unifiedAds.tiles.enabled"}}}}, "newtabSpocsCache": {"description": "The about:newtab sponsored content cache.", "owner": "sdowne@mozilla.com", "hasExposure": false, "variables": {"spocsCacheTimeout": {"type": "int", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.spocs.cacheTimeout"}, "description": "Set sponsored content cache timeout in minutes."}, "spocsStartupCache": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.spocs.startupCache.enabled"}, "description": "Controls if spocs should be included in startup cache."}}}, "newtabAdSizingExperiment": {"description": "Change the default ad size and UI for certain ad formats.", "owner": "achurchwell@mozilla.com, sdowne@mozilla.com", "hasExposure": false, "variables": {"variantA": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabAdSize.variant-a"}, "description": "Variant A ad size and UI."}, "variantB": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabAdSize.variant-b"}, "description": "Variant B ad size and UI."}, "leaderboard": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabAdSize.leaderboard"}, "description": "Leaderboard ad size and UI."}, "leaderboard_position": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabAdSize.leaderboard.position"}, "description": "Leaderboard row position."}, "billboard": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabAdSize.billboard"}, "description": "Billboard ad size and UI."}, "billboard_position": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabAdSize.billboard.position"}, "description": "Billboard row position."}}}, "newtabLayoutExperiment": {"description": "Change the default layout of new tab by adjusting sizes and spacing of elements.", "owner": "achurchwell@mozilla.com, sdowne@mozilla.com", "hasExposure": false, "variables": {"variantA": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabLayouts.variant-a"}, "description": "Variant A in layouts experiment."}, "variantB": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabLayouts.variant-b"}, "description": "Variant B in layouts experiment."}}}, "newtabSponsoredContent": {"description": "Change and control the sponsored content on newtab.", "owner": "sdowne@mozilla.com", "hasExposure": false, "variables": {"spocPositions": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.spoc-positions"}, "description": "CSV string of spoc position indexes on newtab Pocket grid"}, "spocPlacements": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.placements.spocs"}, "description": "CSV string of spoc placement ids on newtab Pocket grid. A placement id tells our ad server where the ads are intended to be displayed."}, "spocCounts": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.placements.spocs.counts"}, "description": "CSV string of spoc placement counts on newtab Pocket grid. The count tells the ad server how many ads to return for this position and placement."}, "tilesPlacements": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.placements.tiles"}, "description": "CSV string of tiles placement ids on newtab tiles section. A placement id tells our ad server where the ads are intended to be displayed."}, "tilesCounts": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.placements.tiles.counts"}, "description": "CSV string of tiles placement counts on newtab tiles section. The count tells the ad server how many ads to return for this position and placement."}}}, "newtabTopicSelection": {"description": "the about:newtab topic selection experience.", "owner": "nbarrett@mozilla.com", "hasExposure": false, "variables": {"availableTopics": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.topicSelection.topics"}, "description": "List of available topics to select for topic selection"}, "suggestedTopics": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.topicSelection.suggestedTopics"}, "description": "List of pre-selected topics to display on first run of topic selection modal"}, "topicSelectionOnboarding": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.topicSelection.onboarding.enabled"}, "description": "Turns on and off topic selection onbaording"}, "regionTopicsConfig": {"description": "A comma-separated list of regions that get topics selection by default.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.topicSelection.region-topics-config"}}, "localeTopicsConfig": {"description": "A comma-separated list of locales that get topics selection by default.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.topicSelection.locale-topics-config"}}, "regionTopicLabelConfig": {"description": "A comma-separated list of regions that get topic labels by default.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.topicLabels.region-topic-label-config"}}, "localeTopicLabelConfig": {"description": "A comma-separated list of locales that get topic Labels by default.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.topicLabels.locale-topic-label-config"}}}}, "newtabContextualContent": {"description": "about:newtab contextual content feed", "owner": "nbarrett@mozilla.com", "hasExposure": false, "variables": {"contextualContentEnabled": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.contextualContent.enabled"}, "description": "Override the contextual content enabled value set via region/locale"}, "localeContextualContentConfig": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.contextualContent.locale-content-config"}, "description": "A comma-separated list of locales that get contextual content by default."}, "regionContextualContentConfig": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.contextualContent.region-content-config"}, "description": "A comma-separated list of regions that get contextual content by default."}, "contextualContentFeeds": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.contextualContent.feeds"}, "description": "CSV list of possible feeds for the contextual content feed"}, "contextualContentSelectedFeed": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.contextualContent.selectedFeed"}, "description": "currently selected feed to display in the Contextual Content component"}}}, "newTabSectionsExperiment": {"description": "about:newtab section UI update", "owner": "nbarrett@mozilla.com, mcrawford@mozilla.com", "hasExposure": false, "variables": {"sectionsEnabled": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.sections.enabled"}, "description": "Enable the Section UI for recommended stories on newtab"}, "cardRefreshThumbsUpDownEnabled": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.sections.cards.thumbsUpDown.enabled"}, "description": "Enable the thumbs up/down buttons in the revised pocket story card UI in recommended stories on newtab"}, "cardRefreshEnabled": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.sections.cards.enabled"}, "description": "Enable the revised pocket story card UI in recommended stories on newtab"}, "localeSectionstConfig": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.sections.locale-content-config"}, "description": "A comma-separated list of locales that get contextual content by default."}, "regionSectionsConfig": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.sections.region-content-config"}, "description": "A comma-separated list of regions that get contextual content by default."}, "sectionsPersonalization": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.sections.personalization.enabled"}, "description": "Enable personalized sections layout. Allow users to follow/unfollow topic sections."}}}, "pocketNewtab": {"description": "The Pocket section in newtab", "owner": "sdowne@mozilla.com", "hasExposure": false, "isEarlyStartup": true, "variables": {"spocTopsitesPositions": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.spoc-topsites-positions", "description": "CSV string of spoc position indexes on newtab topsites section"}, "contileTopsitesPositions": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.contile-topsites-positions", "description": "CSV string of contile position indexes on newtab topsites section"}, "spocAdTypes": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.spocAdTypes", "description": "CSV string of data to set the spoc content."}, "spocZoneIds": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.spocZoneIds", "description": "CSV string of data to set the spoc content."}, "spocTopsitesAdTypes": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.spocTopsitesAdTypes", "description": "CSV string of data to set the spoc content."}, "spocTopsitesZoneIds": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.spocTopsitesZoneIds", "description": "CSV string of data to set the spoc content."}, "spocTopsitesPlacementEnabled": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.spocTopsitesPlacement.enabled", "description": "Tuns on and off the sponsored topsites placement."}, "spocSiteId": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.spocSiteId", "description": "String ID to set the spoc content."}, "widgetPositions": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.widget-positions", "description": "CSV string of widget position indexes on newtab grid"}, "hybridLayout": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.hybridLayout.enabled", "description": "Enable compact cards on newtab grid only for specific breakpoints"}, "hideCardBackground": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.hideCardBackground.enabled", "description": "Removes Pocket card background and borders."}, "fourCardLayout": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.fourCardLayout.enabled", "description": "Enable four Pocket cards per row."}, "newFooterSection": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.newFooterSection.enabled", "description": "Enable an updated Pocket section topics footer"}, "saveToPocketCard": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.saveToPocketCard.enabled", "description": "A save to Pocket button inside the card, shown on the card thumbnail, on hover."}, "saveToPocketCardRegions": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.saveToPocketCardRegions", "description": "CSV string of regions that support the save to Pocket button inside the card."}, "hideDescriptions": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.hideDescriptions.enabled", "description": "Hide or display descriptions for Pocket stories on newtab."}, "hideDescriptionsRegions": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.hideDescriptionsRegions", "description": "CSV string of regions that hide descriptions for Pocket stories on newtab."}, "compactGrid": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.compactGrid.enabled", "description": "Reduce the number of pixels between the Pocket cards on newtab."}, "compactImages": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.compactImages.enabled", "description": "Reduce the height on Pocket card images on newtab."}, "imageGradient": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.imageGradient.enabled", "description": "Add a gradient to the bottom of Pocket card images on newtab to blend the image in with the card."}, "titleLines": {"type": "int", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.titleLines", "description": "Changes the maximum number of lines a title can be for Pocket cards on newtab."}, "descLines": {"type": "int", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.descLines", "description": "Changes the maximum number of lines a description can be for Pocket cards on newtab."}, "onboardingExperience": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.onboardingExperience.enabled", "description": "Enables an onboarding experience for Pocket section on newtab."}, "essentialReadsHeader": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.essentialReadsHeader.enabled", "description": "Updates the Pocket section header and title to say \"Today\u2019s Essential Reads\", moves the \"Recommended by Pocket\" header to the right side."}, "editorsPicksHeader": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.editorsPicksHeader.enabled", "description": "Updates the Pocket section header and title to say \"Editor\u2019s Picks\", if used with essentialReadsHeader, creates a second section 2 rows down for editorsPicksHeader."}, "recentSavesEnabled": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.recentSaves.enabled", "description": "Updates the Pocket section with a new header and 1 row of recently saved Pocket stories."}, "readTime": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.readTime.enabled", "description": "Displays an estimated read time for Pocket cards on newtab."}, "newSponsoredLabel": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.newSponsoredLabel.enabled", "description": "Updates the sponsored label position to below the image for Pocket cards on newtab."}, "sendToPocket": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.sendToPocket.enabled", "description": "Decides what to do when a logged out user click \"Save to Pocket\" from a Pocket card."}, "wallpapers": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabWallpapers.enabled"}, "description": "Turns on and off wallpaper support."}, "wallpapersV2": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabWallpapers.v2.enabled"}, "description": "Turns on and off updated wallpaper experience."}, "wallpapersHighlightEnabled": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabWallpapers.highlightEnabled"}, "description": "Turns on and off wallpaper feature highlight."}, "wallpaperHighlightHeaderText": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabWallpapers.highlightHeaderText"}, "description": "Changes the wallpaper feature highlight header"}, "wallpaperHighlightContentText": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabWallpapers.highlightContentText"}, "description": "Changes the wallpaper feature highlight content"}, "wallpaperHighlightCtaText": {"type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.newtabWallpapers.highlightCtaText"}, "description": "Changes the wallpaper feature highlight cta"}, "weatherLocationSearch": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.weather.locationSearchEnabled"}, "description": "Turns on and off location search for newtab weather widget"}, "recsPersonalized": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.recs.personalized", "description": "Enables Pocket stories personalization."}, "spocsPersonalized": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.spocs.personalized", "description": "Enables Pocket sponsored content personalization."}, "discoveryStreamConfig": {"description": "A JSON blob of discovery stream configuration.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.config"}}, "spocsEndpoint": {"description": "The URL for the spocs endpoint.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.spocs-endpoint"}}, "spocsEndpointAllowlist": {"description": "Comma separated list of allowed endpoints for fetching spocs", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.endpoints"}}, "spocsClearEndpoint": {"description": "URL for deleting any server data when a user opts out of sponsored content", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.endpointSpocsClear"}}, "ctaButtonSponsors": {"description": "A CSV list of sponsors that should use a button CTA.", "type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.ctaButtonSponsors"}, "ctaButtonVariant": {"description": "Specifies which variant to use for any sponsors in ctaButtonSponsors", "type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.ctaButtonVariant"}, "spocMessageVariant": {"description": "Adds some message dialogs explainging sponsored content to the user", "type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.spocMessageVariant"}, "regionStoriesConfig": {"description": "A comma-separated list of region to get stories for.", "type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.region-stories-config"}, "regionBffConfig": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.region-bff-config", "description": "A comma-separated list of regions to get stories from the recommendations BFF. Also requires region-stories-config."}, "merinoProviderEnabled": {"type": "boolean", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.merino-provider.enabled", "description": "Sets the recommendations provider service to Merino."}, "merinoProviderEndpoint": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.merino-provider.endpoint", "description": "Merino endpoint to use for recommendations."}, "regionStoriesBlock": {"description": "A comma-separated list of regions that do not get stories, regardless of locale-list-config.", "type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.region-stories-block"}, "localeListConfig": {"description": "A comma-separated list of locales that get stories, regardless of region-stories-config.", "type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.locale-list-config"}, "regionSpocsConfig": {"description": "A comma-separated list of regions that get spocs by default.", "type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.region-spocs-config"}, "regionWeatherConfig": {"description": "A comma-separated list of regions that get weather by default.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.region-weather-config"}}, "localeWeatherConfig": {"description": "A comma-separated list of locales that weather widget supports.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.locale-weather-config"}}, "topSitesMaxSponsored": {"type": "int", "description": "The maximum number of sponsored Top Sites to be displayed"}, "topSitesContileMaxSponsored": {"type": "int", "description": "The maximum number of sponsored Top Sites used from Contile"}, "topSitesContileSovEnabled": {"description": "Enable the Share-of-Voice feature for Sponsored Topsites.", "type": "boolean", "fallbackPref": "browser.topsites.contile.sov.enabled"}, "pocketFeedParameters": {"type": "string", "fallbackPref": "browser.newtabpage.activity-stream.discoverystream.pocket-feed-parameters", "description": "Add parameters to Pocket feed URL."}, "merinoFeedExperiment": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.merino-feed-experiment"}, "description": "Should we pass the experiment branch and slug to the Merino feed request."}, "thumbsUpDown": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.thumbsUpDown.enabled"}, "description": "Display thumbs up and down buttons on recommended stories"}, "regionThumbsUpDownConfig": {"description": "Display thumbs up and down buttons on recommended stories", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.thumbsUpDown.region-thumbs-config"}}, "localeThumbsUpDownConfig": {"description": "A comma-separated list of locales that get thumbs up and down buttons by default.", "type": "string", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.thumbsUpDown.locale-thumbs-config"}}, "thumbsUpDownCompactLayout": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.newtabpage.activity-stream.discoverystream.thumbsUpDown.searchTopsitesCompact"}, "description": "Change the layout of the sections to be more compact to account for the added card height with the thumbs up/down enabled."}}}, "saveToPocket": {"description": "The save to Pocket feature", "owner": "sdowne@mozilla.com", "hasExposure": false, "variables": {"emailButton": {"type": "boolean", "setPref": {"branch": "user", "pref": "extensions.pocket.refresh.emailButton.enabled"}, "description": "Just for the new Pocket panels, enables the email signup button."}, "hideRecentSaves": {"type": "boolean", "setPref": {"branch": "user", "pref": "extensions.pocket.refresh.hideRecentSaves.enabled"}, "description": "Hides the recently saved section in the home panel."}, "bffRecentSaves": {"type": "boolean", "setPref": {"branch": "user", "pref": "extensions.pocket.bffRecentSaves"}, "description": "Use the new BFF Proxy Service instead of the legacy Pocket Service for Recent Saves"}, "bffApi": {"type": "string", "setPref": {"branch": "user", "pref": "extensions.pocket.bffApi"}, "description": "BFF Proxy Service domain"}, "oAuthConsumerKeyBff": {"type": "string", "setPref": {"branch": "user", "pref": "extensions.pocket.oAuthConsumerKeyBff"}, "description": "BFF Proxy Service OAuth Consumer Key"}}}, "password-autocomplete": {"description": "A special autocomplete UI for password fields.", "owner": "sgalich@mozilla.com", "hasExposure": false, "variables": {"directMigrateSingleProfile": {"type": "boolean", "description": "Enable direct migration?"}}}, "email-autocomplete-relay": {"description": "Relay UI for email fields.", "exposureDescription": "Exposure is sent each time a user sees the Relay autocomplete dropdown item", "hasExposure": true, "owner": "lcrouch@mozilla.com", "variables": {"firstOfferVersion": {"type": "string", "description": "Which Relay UI treatment to show", "fallbackPref": "signon.firefoxRelay.firstOfferVersionFallback"}, "showToAllBrowsers": {"type": "boolean", "setPref": {"branch": "user", "pref": "signon.firefoxRelay.showToAllBrowsers"}, "description": "Whether to show Relay to Firefox users who are NOT signed into FXA."}}}, "address-autofill-feature": {"description": "Enabling address autofill feature", "owner": "issozi@mozilla.com", "hasExposure": false, "variables": {"status": {"type": "boolean", "setPref": {"branch": "default", "pref": "extensions.formautofill.addresses.experiments.enabled"}, "description": "If true, we will allow user to use address autofill"}}}, "creditcards-autofill-enabled": {"description": "Credit card autofill is enabled in all regions", "owner": "issozi@mozilla.com", "hasExposure": false, "variables": {"creditcardsSupported": {"description": "Enable credit card autofill in all regions", "type": "string", "setPref": {"branch": "default", "pref": "extensions.formautofill.creditCards.supported"}}}}, "shellService": {"description": "Interface with OS, e.g., pinning and set default", "owner": "desktop-integrations@mozilla.com", "hasExposure": false, "variables": {"disablePin": {"type": "boolean", "description": "Disable pin to taskbar feature"}, "disableStartMenuPin": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.shell.disableStartMenuPin"}, "description": "Disable pin to start menu feature"}, "setDefaultBrowserUserChoice": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.shell.setDefaultBrowserUserChoice"}, "description": "Should it set as default browser"}, "setDefaultBrowserUserChoiceRegRename": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.shell.setDefaultBrowserUserChoice.regRename"}, "description": "When setting default via UserChoice, rename the underlying registry key to prevent kennel driver registry locking."}, "setDefaultPDFHandler": {"type": "boolean", "fallbackPref": "browser.shell.setDefaultPDFHandler", "description": "Should setting it as the default browser set it as the default PDF handler."}, "setDefaultPDFHandlerOnlyReplaceBrowsers": {"type": "boolean", "fallbackPref": "browser.shell.setDefaultPDFHandler.onlyReplaceBrowsers", "description": "Should setting it as the default PDF handler only replace existing PDF handlers that are browsers, and not other PDF handlers such as Acrobat Reader or Nitro PDF."}, "setDefaultGuidanceNotifications": {"type": "boolean", "fallbackPref": "browser.shell.setDefaultGuidanceNotifications", "description": "Whether or not the user should see the guidance notifications when setting Firefox as their default browser."}}}, "upgradeDialog": {"description": "The dialog shown for major upgrades", "owner": "omc@mozilla.com", "hasExposure": false, "isEarlyStartup": true, "variables": {"enabled": {"type": "boolean", "fallbackPref": "browser.startup.upgradeDialog.enabled", "description": "Is the feature enabled?"}}}, "cfr": {"description": "A Firefox Messaging System message for the cfr message channel", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "moments-page": {"description": "A Firefox Messaging System message for the moments-page message channel", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "infobar": {"description": "A Firefox Messaging system message for the infobar message channel", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "spotlight": {"description": "A Firefox Messaging System message for the spotlight message channel", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "featureCallout": {"description": "A Firefox Messaging System message for the Feature Callout message channel", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fullPageTranslation": {"description": "This feature opens a popup panel to offer to translate a page.", "owner": "gtatum@mozilla.com", "hasExposure": false, "variables": {"boolean": {"description": "Set to true to enable the translations feature", "type": "boolean", "setPref": {"branch": "user", "pref": "browser.translations.enable"}}}}, "fullPageTranslationAutomaticPopup": {"description": "Controls whether the popup automatically shows for translations.", "owner": "gtatum@mozilla.com", "hasExposure": false, "variables": {"boolean": {"description": "Set to true to automatically popup, and false to only show the button.", "type": "boolean", "setPref": {"branch": "user", "pref": "browser.translations.automaticallyPopup"}}}}, "selectTranslation": {"description": "This feature enables the option to translate selected text from the context menu.", "owner": "enordin@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "Set to true to enable the select-translations feature", "type": "boolean", "setPref": {"branch": "user", "pref": "browser.translations.select.enable"}}}}, "pdfjs": {"description": "The Firefox pdf reader.", "owner": "pdfjs-team@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent each time a pdf is displayed.", "variables": {"enableAltText": {"description": "Set to true to enable alt text generation.", "type": "boolean", "setPref": {"branch": "default", "pref": "pdfjs.enableAltText"}}, "enableUpdatedAddImage": {"description": "Set to true to enable updated add image with alt text flow.", "type": "boolean", "setPref": {"branch": "default", "pref": "pdfjs.enableUpdatedAddImage"}}, "browserMlEnable": {"description": "Set to true to enable local inference engine", "type": "boolean", "setPref": {"branch": "default", "pref": "browser.ml.enable"}}}}, "fxms-message-1": {"description": "A Firefox Messaging System message", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-2": {"description": "Firefox Messaging System message 2", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-3": {"description": "Firefox Messaging System message 3", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-4": {"description": "Firefox Messaging System message 4", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-5": {"description": "Firefox Messaging System message 5", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-6": {"description": "Firefox Messaging System message 6", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-7": {"description": "Firefox Messaging System message 7", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-8": {"description": "Firefox Messaging System message 8", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-9": {"description": "Firefox Messaging System message 9", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-10": {"description": "Firefox Messaging System message 10", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-11": {"description": "Firefox Messaging System message 11", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-12": {"description": "Firefox Messaging System message 12", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-13": {"description": "Firefox Messaging System message 13", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-14": {"description": "Firefox Messaging System message 14", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "fxms-message-15": {"description": "Firefox Messaging System message 15", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "whatsNewPage": {"description": "A Firefox Messaging System message for the What's new page channel", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "variables": {"overrideUrl": {"description": "URL of the What's new page", "type": "string", "setPref": {"branch": "user", "pref": "startup.homepage_override_url_nimbus"}}, "maxVersion": {"description": "Maximum Firefox update version", "type": "string", "setPref": {"branch": "user", "pref": "startup.homepage_override_nimbus_maxVersion"}}, "minVersion": {"description": "Minimum Firefox update version", "type": "string", "setPref": {"branch": "user", "pref": "startup.homepage_override_nimbus_minVersion"}}, "disableWNP": {"description": "Block all What's New Pages. Used to compare no-WNP control branches to WNP treatment branches.", "type": "boolean", "setPref": {"branch": "user", "pref": "startup.homepage_override_nimbus_disable_wnp"}}}}, "pbNewtab": {"description": "A Firefox Messaging System message for the pbNewtab message channel", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "backgroundTaskMessage": {"description": "A Firefox Messaging System message for the background task message channel", "owner": "nalexander@mozilla.com", "applications": ["firefox-desktop-background-task"], "hasExposure": true, "exposureDescription": "Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.", "schema": {"uri": "chrome://browser/content/asrouter/schemas/BackgroundTaskMessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/BackgroundTaskMessagingExperiment.schema.json"}, "variables": {}}, "backgroundUpdateAutomaticRestart": {"description": "Whether to automatically restart when the background update task could make more progress.", "owner": "nalexander@mozilla.com", "applications": ["firefox-desktop-background-task"], "hasExposure": false, "variables": {"enabled": {"type": "boolean", "fallbackPref": "app.update.background.automaticRestartEnabled", "description": "When true, make the background update task restart when the final update state is `READY_FOR_RESTART`. Generally, this will finish applying a staged update, completing the update earlier than it otherwise would have been completed."}}}, "pictureinpicture": {"description": "Message for first time Picture-in-Picture users", "owner": "nbaumgardner@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent when a user hovers over a video and Picture-in-Picture has not been used before", "variables": {"title": {"type": "string", "description": "The title to be used for the PiP toggle"}, "message": {"type": "string", "description": "The message to be used in the PiP toggle"}, "showIconOnly": {"type": "boolean", "description": "Whether to show the first time PiP toggle or show the PiP icon only"}, "oldToggle": {"type": "boolean", "description": "Whether to show the control style (true) or variant style (false) for the first time PiP toggle"}, "displayDuration": {"type": "int", "description": "Duration of PiP first time toggle display in days before switching to PiP icon toggle"}}}, "glean": {"description": "The Glean data-control-plane feature within Firefox Desktop for controlling metric configuration", "owner": "glean-team@mozilla.com", "hasExposure": false, "variables": {"newtabPingEnabled": {"type": "boolean", "fallbackPref": "browser.newtabpage.ping.enabled", "description": "Whether to submit the 'newtab' ping"}, "gleanMetricConfiguration": {"type": "json", "description": "A map of metric base-identifiers to booleans representing the state of the 'enabled' flag for that metric.\nThis variable is intended for interacting with the Glean data-control-plane via the Server Knobs functionality\nto remotely configure metrics to be enabled or disabled.\n"}}}, "gleanInternalSdk": {"description": "The Glean internal SDK feature intended only for internal Glean Team use", "owner": "glean-team@mozilla.com", "hasExposure": false, "variables": {"finalInactive": {"type": "boolean", "description": "Enables FOG early shutdown pings when true", "setPref": {"branch": "user", "pref": "telemetry.glean.internal.finalInactive"}}, "gleanMetricConfiguration": {"type": "json", "description": "A map of metric base-identifiers to booleans representing the state of the 'enabled' flag for that metric.\nThis is not for public use! For data-control-plane use, please refer to the Glean documentation and use the\n`gleanMetricConfiguration` found in the `glean` feature for this.\n"}, "gleanMaxPingsPerMinute": {"type": "int", "description": "Maximum number of pings that can be sent in a 60 second interval", "setPref": {"branch": "user", "pref": "telemetry.glean.internal.maxPingsPerMinute"}}}}, "browserLowMemoryPrefs": {"description": "Prefs which control the browser's behaviour under low memory.", "owner": "haftandilian@mozilla.com", "hasExposure": false, "variables": {"lowMemoryResponseMask": {"description": "Control the response on macOS when under memory pressure.", "type": "int", "setPref": {"branch": "default", "pref": "browser.lowMemoryResponseMask"}}, "lowMemoryResponseOnWarn": {"description": "Controls which macOS memory-pressure levels trigger the browser low memory response.", "type": "boolean", "setPref": {"branch": "default", "pref": "browser.lowMemoryResponseOnWarn"}}, "tabsUnloadOnLowMemory": {"description": "Whether to unload tabs when available memory is running low.", "type": "boolean", "setPref": {"branch": "default", "pref": "browser.tabs.unloadOnLowMemory"}}}}, "scriptLoaderPrefs": {"description": "Prefs that control the script loader.", "owner": "npierron@mozilla.com", "hasExposure": false, "variables": {"delazificationStrategy": {"description": "Selects which parsing/delazification strategy should be used while parsing scripts off-main-thread. See DelazificationOption in CompileOptions.h for values.", "type": "int", "setPref": {"branch": "default", "pref": "dom.script_loader.delazification.strategy"}}}}, "echPrefs": {"description": "Prefs that control Encrypted Client Hello.", "owner": "djackson@mozilla.com", "hasExposure": false, "variables": {"tlsEnabled": {"description": "Whether to enable ECH for connections using TLS", "type": "boolean", "setPref": {"branch": "default", "pref": "network.dns.echconfig.enabled"}}, "h3Enabled": {"description": "Whether to enable ECH for connections using H3/QUIC", "type": "boolean", "setPref": {"branch": "default", "pref": "network.dns.http3_echconfig.enabled"}}, "forceWaitHttpsRR": {"description": "Whether to force waiting for HTTPS DNS records, which ECH requires.", "type": "boolean", "setPref": {"branch": "default", "pref": "network.dns.force_waiting_https_rr"}}, "insecureFallback": {"description": "Whether to fallback to non-ECH connections if all ECH RRs fail.", "type": "boolean", "setPref": {"branch": "default", "pref": "network.dns.echconfig.fallback_to_origin_when_all_failed"}}, "tlsGreaseProb": {"description": "Probability of GREASEing a TLS connection with ECH (0-100).", "type": "int", "setPref": {"branch": "default", "pref": "security.tls.ech.grease_probability"}}, "h3GreaseEnabled": {"description": "Whether to apply GREASE settings to H3/QUIC connections.", "type": "boolean", "setPref": {"branch": "default", "pref": "security.tls.ech.grease_http3"}}, "disableGreaseOnFallback": {"description": "Whether to disable GREASE when retrying a connection.", "type": "boolean", "setPref": {"branch": "default", "pref": "security.tls.ech.disable_grease_on_fallback"}}, "greasePaddingSize": {"description": "Assumed echConfig padding length for GREASE extensions (1-255).", "type": "int", "setPref": {"branch": "default", "pref": "security.tls.ech.grease_size"}}}}, "dohPrefs": {"description": "Prefs that control DNS over HTTPS.", "owner": "vgosu@mozilla.com", "hasExposure": false, "variables": {"trrMode": {"description": "Has a value of 2 for TRR first, 3 for TRR only, 0 for off.", "type": "int", "setPref": {"branch": "default", "pref": "network.trr.mode"}}, "trrUri": {"description": "The URL of the DNS over HTTPS endpoint", "type": "string", "setPref": {"branch": "default", "pref": "network.trr.uri"}}, "dohMode": {"description": "Same as trrMode, but set by the DoHController module.", "type": "int", "setPref": {"branch": "default", "pref": "doh-rollout.mode"}}, "dohUri": {"description": "Same as trrUri, but set by the DoHController module.", "type": "string", "setPref": {"branch": "default", "pref": "doh-rollout.uri"}}, "enableFallbackWarningPage": {"description": "Whether DoH fallback warning page will be displayed when DoH doesn't work in TRR first mode.", "type": "boolean", "setPref": {"branch": "default", "pref": "network.trr.display_fallback_warning"}}, "showFallbackCheckbox": {"description": "Whether the checkbox to enable the fallback warning page is displayed in the settings UI.", "type": "boolean", "setPref": {"branch": "default", "pref": "network.trr_ui.show_fallback_warning_option"}}, "nativeHTTPSRecords": {"description": "Whether we can perform native DNS HTTPS lookups", "type": "boolean", "setPref": {"branch": "default", "pref": "network.dns.native_https_query"}}}}, "dooh": {"description": "DNS over Oblivious HTTP", "owner": "vgosu@mozilla.com", "hasExposure": false, "variables": {"ohttpEnabled": {"description": "Whether to use Oblivious HTTP for the resolution", "type": "boolean", "setPref": {"branch": "default", "pref": "network.trr.use_ohttp"}}, "ohttpRelayUri": {"description": "The URL of the Oblivious HTTP relay", "type": "string", "setPref": {"branch": "default", "pref": "network.trr.ohttp.relay_uri"}}, "ohttpConfigUri": {"description": "The URL used to fetch the configuration of the Oblivious HTTP gateway", "type": "string", "setPref": {"branch": "default", "pref": "network.trr.ohttp.config_uri"}}, "ohttpUri": {"description": "The URL of the Oblivious DNS over HTTPS target resource", "type": "string", "setPref": {"branch": "default", "pref": "network.trr.ohttp.uri"}}}}, "networking": {"description": "Firefox Networking (Necko)", "owner": "vgosu@mozilla.com", "hasExposure": false, "variables": {"ehPreloadEnabled": {"description": "Whether Early Hints preload is enabled", "type": "boolean", "setPref": {"branch": "default", "pref": "network.early-hints.enabled"}}, "ehPreconnectEnabled": {"description": "Whether Early Hints preconnect is enabled", "type": "boolean", "setPref": {"branch": "default", "pref": "network.early-hints.preconnect.enabled"}}, "dnsMaxPriorityThreads": {"description": "The maximum number of high priority DNS threads that can be created.", "type": "int", "setPref": {"branch": "default", "pref": "network.dns.max_high_priority_threads"}}, "dnsMaxAnyPriorityThreads": {"description": "The maximum number of DNS threads that can be created to handle any priority DNS requests.", "type": "int", "setPref": {"branch": "default", "pref": "network.dns.max_any_priority_threads"}}, "preconnect": {"description": "Whether the rel=preconnect feature is enabled", "type": "boolean", "setPref": {"branch": "default", "pref": "network.preconnect"}}, "networkPredictor": {"description": "Whether the Necko predictor is enabled", "type": "boolean", "setPref": {"branch": "default", "pref": "network.predictor.enabled"}}, "http3CCalgorithm": {"description": "The congestion control algorithm with which to configure neqo. 0 for NewReno, 1 for Cubic", "type": "int", "setPref": {"branch": "default", "pref": "network.http.http3.cc_algorithm"}}, "sendOnDataFinished": {"description": "Whether we can send OnDataFinished in the content process", "type": "boolean", "setPref": {"branch": "default", "pref": "network.send_OnDataFinished"}}, "sendOnDataFinshedFromInputStreamPump": {"description": "Whether we can send OnDataFinished to the content process from InputStreamPump", "type": "boolean", "setPref": {"branch": "default", "pref": "network.send_OnDataFinished.nsInputStreamPump"}}, "sendOnDataFinishedToHtml5parser": {"description": "Whether we can send OnDataFinished to the html5parser in content process", "type": "boolean", "setPref": {"branch": "default", "pref": "network.send_OnDataFinished.html5parser"}}, "sendOnDataFinishedToCssLoader": {"description": "Whether we can send OnDataFinished to the cssLoader in content process", "type": "boolean", "setPref": {"branch": "default", "pref": "network.send_OnDataFinished.cssLoader"}}, "enableOffMainThreadStreamDecompression": {"description": "Whether to enable decompression of network streams off-main-thread", "type": "boolean", "setPref": {"branch": "default", "pref": "network.decompression_off_mainthread2"}}, "offMainThreadStreamDecompressionThreshold": {"description": "Minimum content length for off-main-thread decompression", "type": "int", "setPref": {"branch": "default", "pref": "network.decompression_off_mainthread_min_size"}}, "httpMaxConnections": {"description": "The maximum number of http connections.", "type": "int", "setPref": {"branch": "default", "pref": "network.http.max-connections"}}, "httpMaxPersistentConnectionsPerServer": {"description": "The maximum number of persistent connections to a server", "type": "int", "setPref": {"branch": "default", "pref": "network.http.max-persistent-connections-per-server"}}, "speculativeConnectionLimit": {"description": "The maximum number of half-open sockets allowed for speculative connections", "type": "int", "setPref": {"branch": "default", "pref": "network.http.speculative-parallel-limit"}}, "chipsEnabled": {"description": "Whether CHIPS is enabled or not", "type": "boolean", "setPref": {"branch": "default", "pref": "network.cookie.CHIPS.enabled"}}, "chipsMigrationTarget": {"description": "What CHIPS migration count target the browser should reach.", "type": "int", "setPref": {"branch": "default", "pref": "network.cookie.CHIPS.migrateDatabaseTarget"}}, "chipsPartitionLimitEnabled": {"description": "Whether we enforce CHIPS partition limit", "type": "boolean", "setPref": {"branch": "default", "pref": "network.cookie.chips.partitionLimitEnabled"}}, "chipsPartitionLimitDryRun": {"description": "Whether we actually perform purging/rejection, used to report telemetry without webcompat issues", "type": "boolean", "setPref": {"branch": "default", "pref": "network.cookie.chips.partitionLimitDryRun"}}, "chipsPartitionLimitByteCapacity": {"description": "The actual value of the CHIPS partition limit in bytes", "type": "boolean", "setPref": {"branch": "default", "pref": "network.cookie.chips.partitionLimitByteCapacity"}}, "dnsGracePeriod": {"description": "The grace period allows the DNS cache to use expired entries, while kicking off a revalidation in the background.", "type": "int", "setPref": {"branch": "default", "pref": "network.dnsCacheExpirationGracePeriod"}}, "maxDnsCacheEntries": {"description": "This is the number of dns cache entries allowed", "type": "int", "setPref": {"branch": "default", "pref": "network.dnsCacheEntries"}}}}, "disableHttp3": {"description": "Whether HTTP/3 is disabled", "owner": "kershaw@mozilla.com", "hasExposure": false, "variables": {"withThirdPartyRoots": {"description": "If third party roots are detected, disable HTTP/3", "type": "boolean", "setPref": {"branch": "default", "pref": "network.http.http3.disable_when_third_party_roots_found"}}}}, "networkPrioritization": {"description": "Network request prioritization", "owner": "vgosu@mozilla.com", "hasExposure": false, "variables": {"priorityHeader": {"description": "Whether to set the Priority header on each request.", "type": "boolean", "setPref": {"branch": "default", "pref": "network.http.priority_header.enabled"}}, "fetchPriority": {"description": "Whether fetch priority is enabled", "type": "boolean", "setPref": {"branch": "default", "pref": "network.fetchpriority.enabled"}}, "h3FetchPriority": {"description": "Whether to send HTTP3 priority frames", "type": "boolean", "setPref": {"branch": "default", "pref": "network.http.http3.priority"}}, "sendNoRFC7540Setting": {"description": "Whether to send the SETTINGS_NO_RFC7540_PRIORITIES for the HTTP2 session.", "type": "boolean", "setPref": {"branch": "default", "pref": "network.http.http2.send_NO_RFC7540_PRI"}}, "h2deps": {"description": "Whether RFC7540 priorities / stream dependencies are enabled", "type": "boolean", "setPref": {"branch": "default", "pref": "network.http.http2.enabled.deps"}}, "h3BackgroundTabDeprioritization": {"description": "Lowers the priority when the tab is in the background. Potential privacy concerns.", "type": "boolean", "setPref": {"branch": "default", "pref": "network.http.http3.send_background_tabs_deprioritization"}}, "documentPriorityIncremental": {"description": "Sets the incremental flag on the Priority header for document requests", "type": "boolean", "setPref": {"branch": "default", "pref": "dom.document_priority.incremental"}}, "imagePriorityIncremental": {"description": "Sets the incremental flag on the Priority header for image requests", "type": "boolean", "setPref": {"branch": "default", "pref": "image.priority.incremental"}}, "imageAdjustLayoutPriority": {"description": "Whether the network request priority should be adjusted according the layout and view frame position of each particular image.", "type": "boolean", "setPref": {"branch": "default", "pref": "image.layout_network_priority"}}, "adjustLinkPreloadScriptLow": {"description": "Priority adjustment low for link-preload-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-script.low"}}, "adjustLinkPreloadScriptHigh": {"description": "Priority adjustment high for link-preload-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-script.high"}}, "adjustLinkPreloadScriptAuto": {"description": "Priority adjustment auto for link-preload-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-script.auto"}}, "adjustModuleScriptLow": {"description": "Priority adjustment low for module-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.module-script.low"}}, "adjustModuleScriptHigh": {"description": "Priority adjustment high for module-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.module-script.high"}}, "adjustModuleScriptAuto": {"description": "Priority adjustment auto for module-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.module-script.auto"}}, "adjustAsyncOrDeferScriptLow": {"description": "Priority adjustment low for async-or-defer-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.async-or-defer-script.low"}}, "adjustAsyncOrDeferScriptHigh": {"description": "Priority adjustment high for async-or-defer-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.async-or-defer-script.high"}}, "adjustAsyncOrDeferScriptAuto": {"description": "Priority adjustment auto for async-or-defer-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.async-or-defer-script.auto"}}, "adjustScriptInHeadLow": {"description": "Priority adjustment low for script-in-head", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.script-in-head.low"}}, "adjustScriptInHeadHigh": {"description": "Priority adjustment high for script-in-head", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.script-in-head.high"}}, "adjustScriptInHeadAuto": {"description": "Priority adjustment auto for script-in-head", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.script-in-head.auto"}}, "adjustOtherScriptLow": {"description": "Priority adjustment low for other-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.other-script.low"}}, "adjustOtherScriptHigh": {"description": "Priority adjustment high for other-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.other-script.high"}}, "adjustOtherScriptAuto": {"description": "Priority adjustment auto for other-script", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.other-script.auto"}}, "adjustLinkPreloadFontLow": {"description": "Priority adjustment low for link-preload-font", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-font.low"}}, "adjustLinkPreloadFontHigh": {"description": "Priority adjustment high for link-preload-font", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-font.high"}}, "adjustLinkPreloadFontAuto": {"description": "Priority adjustment auto for link-preload-font", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-font.auto"}}, "adjustLinkPreloadFetchLow": {"description": "Priority adjustment low for link-preload-fetch", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-fetch.low"}}, "adjustLinkPreloadFetchHigh": {"description": "Priority adjustment high for link-preload-fetch", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-fetch.high"}}, "adjustLinkPreloadFetchAuto": {"description": "Priority adjustment auto for link-preload-fetch", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-fetch.auto"}}, "adjustDeferredStyleLow": {"description": "Priority adjustment low for deferred-style", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.deferred-style.low"}}, "adjustDeferredStyleHigh": {"description": "Priority adjustment high for deferred-style", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.deferred-style.high"}}, "adjustDeferredStyleAuto": {"description": "Priority adjustment auto for deferred-style", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.deferred-style.auto"}}, "adjustLinkPreloadStyleLow": {"description": "Priority adjustment low for link-preload-style", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-style.low"}}, "adjustLinkPreloadStyleHigh": {"description": "Priority adjustment high for link-preload-style", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-style.high"}}, "adjustLinkPreloadStyleAuto": {"description": "Priority adjustment auto for link-preload-style", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.link-preload-style.auto"}}, "adjustNonDeferredStyleLow": {"description": "Priority adjustment low for non-deferred-style", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.non-deferred-style.low"}}, "adjustNonDeferredStyleHigh": {"description": "Priority adjustment high for non-deferred-style", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.non-deferred-style.high"}}, "adjustNonDeferredStyleAuto": {"description": "Priority adjustment auto for non-deferred-style", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.non-deferred-style.auto"}}, "adjustGlobalFetchApiLow": {"description": "Priority adjustment low for global-fetch-api", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.global-fetch-api.low"}}, "adjustGlobalFetchApiHigh": {"description": "Priority adjustment high for global-fetch-api", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.global-fetch-api.high"}}, "adjustGlobalFetchApiAuto": {"description": "Priority adjustment auto for global-fetch-api", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.global-fetch-api.auto"}}, "adjustImagesLow": {"description": "Priority adjustment low for images", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.images.low"}}, "adjustImagesHigh": {"description": "Priority adjustment high for images", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.images.high"}}, "adjustImagesAuto": {"description": "Priority adjustment auto for images", "type": "int", "setPref": {"branch": "default", "pref": "network.fetchpriority.adjustments.images.auto"}}, "lowerTrackersPriority": {"description": "Whether to lower priority of resources on the tracking protection list", "type": "boolean", "setPref": {"branch": "default", "pref": "privacy.trackingprotection.lower_network_priority"}}, "enableHttpTailing": {"description": "Whether certain requests, mainly trackers, are put to the \"tail\", behind other requests", "type": "boolean", "setPref": {"branch": "default", "pref": "network.http.tailing.enabled"}}, "httpTailingUrgency": {"description": "Priority urgency of tailed request", "type": "int", "setPref": {"branch": "default", "pref": "network.http.tailing.urgency"}}, "httpTailingDelayQuantum": {"description": "When the page load has not yet reached DOMContentLoaded point, tail requestes are delayed by (non-tailed requests count + 1) * delay-quantum milliseconds.", "type": "int", "setPref": {"branch": "default", "pref": "network.http.tailing.delay-quantum"}}, "httpTailingDelayQuantumAfterDCL": {"description": "After the page load reached DOMContentLoaded point, tail requestes are delayed by (non-tailed requests count + 1) * delay-quantum-after-domcontentloaded milliseconds.", "type": "int", "setPref": {"branch": "default", "pref": "network.http.tailing.delay-quantum-after-domcontentloaded"}}, "httpTailingMaxDelay": {"description": "Upper limit for the calculated delay, prevents long standing and comet-like requests", "type": "int", "setPref": {"branch": "default", "pref": "network.http.tailing.delay-max"}}, "httpTailingTotalMaxDelay": {"description": "Total limit we delay tailed requests since page load start", "type": "int", "setPref": {"branch": "default", "pref": "network.http.tailing.total-max"}}}}, "networkingAuth": {"description": "Firefox Networking (Necko) Authentication", "owner": "vgosu@mozilla.com", "hasExposure": false, "variables": {"redirectForAuthRetriesEnabled": {"description": "Whether to enable redirects for auth retries", "type": "boolean", "setPref": {"branch": "default", "pref": "network.auth.use_redirect_for_retries"}}}}, "networkingDenyIpAddrAny": {"description": "Firefox Networking (Necko) Deny IP Address Any", "owner": "vgosu@mozilla.com", "hasExposure": false, "variables": {"denyIpAddrAny": {"description": "Whether to deny empty (0.0.0.0) IP addresses", "type": "boolean", "setPref": {"branch": "default", "pref": "network.socket.ip_addr_any.disabled"}}}}, "pingsender": {"description": "In-product usage of the pingsender telemetry reporter.", "owner": "nalexander@mozilla.com", "hasExposure": false, "variables": {"backgroundTaskEnabled": {"type": "boolean", "fallbackPref": "toolkit.telemetry.shutdownPingSender.backgroundtask.enabled", "description": "Whether to use the `pingsender` background task to send shutdown telemetry"}}}, "dapTelemetry": {"description": "DAP Telemetry", "owner": "simon@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "boolean", "description": "Whether to automatically send DAP measurements."}, "task1Enabled": {"type": "boolean", "description": "Whether to send fake measurements for task 1."}, "task1TaskId": {"type": "string", "description": "The task ID to use for task 1 measurements."}, "visitCountingEnabled": {"type": "boolean", "description": "Whether to count visits to the provided list of URLs."}, "visitCountingExperimentList": {"type": "json", "description": "A list of experiments with URLs for which we want to count visits."}}}, "dapAggregators": {"description": "Aggregator server configuration to use for submitting DAP reports.", "owner": "tcampbell@mozilla.com", "hasExposure": false, "variables": {"leader_url": {"description": "The URL of the DAP Leader server where reports are submitted.", "type": "string", "setPref": {"branch": "default", "pref": "toolkit.telemetry.dap.leader.url"}}, "leader_hpke": {"description": "The base64-encode HPKE key to encrypt leader shares with.", "type": "string", "setPref": {"branch": "default", "pref": "toolkit.telemetry.dap.leader.hpke"}}, "helper_url": {"description": "The URL of the DAP Helper server.", "type": "string", "setPref": {"branch": "default", "pref": "toolkit.telemetry.dap.helper.url"}}, "helper_hpke": {"description": "The base64-encode HPKE key to encrypt helper shares with.", "type": "string", "setPref": {"branch": "default", "pref": "toolkit.telemetry.dap.helper.hpke"}}}}, "etpLevel2PBMPref": {"description": "The pref that controls the ETP level 2 list in the private browsing mode", "owner": "tihuang@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "Whether to enable ETP level 2 list in the private browsing mode.", "type": "boolean", "setPref": {"branch": "default", "pref": "privacy.annotate_channels.strict_list.pbmode.enabled"}}}}, "etpStrictFeatures": {"description": "Prefs to control the strict ETP features", "owner": "tihuang@mozilla.com", "hasExposure": false, "variables": {"features": {"description": "The list of strict ETP features to enable in ETP strict mode.", "type": "string", "setPref": {"branch": "default", "pref": "browser.contentblocking.features.strict"}}}}, "thirdPartyCookieBlocking": {"description": "Prefs to control third-party cookie blocking", "owner": "tihuang@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "Whether to enable third-party cookie blocking", "type": "boolean", "setPref": {"branch": "default", "pref": "network.cookie.cookieBehavior.optInPartitioning"}}, "enabledPBM": {"description": "Whether to enable third-party cookie blocking in private browsing mode", "type": "boolean", "setPref": {"branch": "default", "pref": "network.cookie.cookieBehavior.optInPartitioning.pbmode"}}}}, "thirdPartyTrackerCookieBlocking": {"description": "Prefs to control third-party tracker cookie blocking", "owner": "tihuang@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "Whether to enable third-party tracker cookie blocking.", "type": "boolean", "setPref": {"branch": "default", "pref": "network.cookie.cookieBehavior.trackerCookieBlocking"}}}}, "fxaButtonVisibility": {"description": "Prefs to control the visibility of the Firefox Accounts toolbar button when not signed in.", "owner": "mconley@mozilla.com", "hasExposure": false, "variables": {"boolean": {"description": "True if the Firefox Accounts toolbar button should be visible when not signed in.", "type": "boolean", "setPref": {"branch": "user", "pref": "identity.fxaccounts.toolbar.defaultVisible"}}, "pxiToolbarEnabled": {"description": "True if we're enabling the PXI dropdown menu for the FxA toolbar button instead of taking the user straight to login", "type": "boolean", "setPref": {"branch": "user", "pref": "identity.fxaccounts.toolbar.pxiToolbarEnabled"}}, "monitorEnabled": {"description": "Toggle the Monitor CTA", "type": "boolean", "setPref": {"branch": "user", "pref": "identity.fxaccounts.toolbar.pxiToolbarEnabled.monitorEnabled"}}, "relayEnabled": {"description": "Toggle the Relay CTA", "type": "boolean", "setPref": {"branch": "user", "pref": "identity.fxaccounts.toolbar.pxiToolbarEnabled.relayEnabled"}}, "vpnEnabled": {"description": "Toggle the VPN CTA", "type": "boolean", "setPref": {"branch": "user", "pref": "identity.fxaccounts.toolbar.pxiToolbarEnabled.vpnEnabled"}}, "avatarIconVariant": {"description": "Controls the icon that appears in the toolbar button when in the signed-out state.\nOne of the following values:\n  - control\n  - human-circle\n  - fox-circle", "type": "string"}}}, "syncSetupFlow": {"description": "Prefs to control the updated Mozilla account panel flow for users without sync enabled.", "owner": "skhamis@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is recorded when the user is enrolled in an experiment using this feature and the avatar menu or app (hamburger) menu -> account on Firefox Desktop is opened", "variables": {"enabled": {"description": "True if we should show the user the updated sync set-up UI", "type": "boolean", "setPref": {"branch": "user", "pref": "identity.fxaccounts.toolbar.syncSetup.enabled"}}}}, "fxaClientAssociation": {"description": "Prefs to control the client association ping.", "owner": "mconley@mozilla.com", "hasExposure": false, "variables": {"pingEnabled": {"description": "True if the client association ping should be sent.", "type": "boolean", "setPref": {"branch": "user", "pref": "identity.fxaccounts.telemetry.clientAssociationPing.enabled"}}}}, "fxaAppMenuItem": {"description": "Prefs to control the appearance and copy of the FxA sign-in button in the AppMenu when signed out.", "owner": "mconley@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is recorded when the user is enrolled in an experiment using this feature and the AppMenu on Firefox Desktop is opened.", "variables": {"ctaCopyVariant": {"description": "One of the following values:\n  - control\n  - sync-devices\n  - backup-data\n  - backup-sync\n  - mobile", "type": "string"}}}, "fxaAvatarMenuItem": {"description": "Prefs to control the appearance and copy of the FxA sign-in button in the FxA avatar menu when signed out.", "owner": "mconley@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is recorded when the user is enrolled in an experiment using this feature and the FxA avatar menu on Firefox Desktop is opened.", "variables": {"ctaCopyVariant": {"description": "One of the following values:\n  - control\n  - sync-devices\n  - backup-data\n  - backup-sync\n  - mobile", "type": "string"}}}, "legacyHeartbeat": {"description": "Normandy Heartbeat exposed to Nimbus", "owner": "beth@mozilla.com", "hasExposure": false, "schema": {"uri": "resource://normandy/schemas/LegacyHeartbeat.schema.json", "path": "toolkit/components/normandy/schemas/LegacyHeartbeat.schema.json"}, "variables": {"survey": {"type": "json", "description": "The Heartbeat survey parameters."}}}, "queryStripping": {"description": "Query parameter stripping anti-tracking feature.", "owner": "emz@mozilla.com", "hasExposure": false, "variables": {"enabledNormalBrowsing": {"type": "boolean", "setPref": {"branch": "default", "pref": "privacy.query_stripping.enabled"}, "description": "Enables / disables URL query string stripping in normal browsing mode."}, "enabledPrivateBrowsing": {"type": "boolean", "setPref": {"branch": "default", "pref": "privacy.query_stripping.enabled.pbmode"}, "description": "Enables / disables URL query string stripping in private browsing mode."}, "allowList": {"type": "string", "setPref": {"branch": "default", "pref": "privacy.query_stripping.allow_list"}, "description": "List of sites exempt from query stripping. This list will be merged with records coming from RemoteSettings."}, "stripList": {"type": "string", "setPref": {"branch": "default", "pref": "privacy.query_stripping.strip_list"}, "description": "List of query params to be stripped from URIs. This list will be merged with records coming from RemoteSettings."}}}, "fontvisibility": {"description": "Control Font Visibility in PBM", "owner": "tom@mozilla.com", "hasExposure": false, "variables": {"enabledETP": {"type": "int", "setPref": {"branch": "default", "pref": "layout.css.font-visibility.trackingprotection"}, "description": "Set the Font Visibility level when Enhanced Tracking Protection is enabled"}, "enabledStandard": {"type": "int", "setPref": {"branch": "default", "pref": "layout.css.font-visibility.standard"}, "description": "Set the Font Visibility level for normal browsing"}, "enabledPBM": {"type": "int", "setPref": {"branch": "default", "pref": "layout.css.font-visibility.private"}, "description": "Set the Font Visibility level for private browsing (will override ETP)"}}}, "fingerprintingProtection": {"description": "Control Fingerprinting Protection", "owner": "tihuang@mozilla.com", "hasExposure": false, "variables": {"enabledNormal": {"type": "boolean", "setPref": {"branch": "default", "pref": "privacy.fingerprintingProtection"}, "description": "Enables / disables fingerprinting protection in normal browsing mode."}, "enabledPrivate": {"type": "boolean", "setPref": {"branch": "default", "pref": "privacy.fingerprintingProtection.pbmode"}, "description": "Enables / disables fingerprinting protection in private browsing mode."}, "overrides": {"type": "string", "setPref": {"branch": "default", "pref": "privacy.fingerprintingProtection.overrides"}, "description": "The protection overrides to add or remove fingerprinting protection targets. Please check RFPTargets.inc for all supported targets."}, "fdlibm_math": {"type": "boolean", "setPref": {"branch": "default", "pref": "javascript.options.use_fdlibm_for_sin_cos_tan"}, "description": "Uses a different math backend for Math.sin/cos/tan in JavaScript that exposes less entropy"}, "canvas_random_use_siphash": {"type": "boolean", "setPref": {"branch": "default", "pref": "privacy.resistFingerprinting.randomization.canvas.use_siphash"}, "description": "Uses the SipHash function for canvas randomization."}}}, "userCharacteristics": {"description": "Control user characteristic data collection", "owner": "tihuang@mozilla.com", "hasExposure": false, "variables": {"currentVersion": {"type": "int", "setPref": {"branch": "user", "pref": "toolkit.telemetry.user_characteristics_ping.current_version"}, "description": "The current collection version of the user characteristics."}}}, "migrationWizard": {"description": "Prefs to control the Migration Wizard UI.", "owner": "mconley@mozilla.com", "hasExposure": false, "variables": {"showImportAll": {"description": "True if the \"Variant 2\" of the Migration Wizard browser / profile selection UI should be used. This is only meaningful in the new Migration Wizard.", "type": "boolean", "setPref": {"branch": "user", "pref": "browser.migrate.content-modal.import-all.enabled"}}, "showPreferencesEntrypoint": {"description": "True if an entrypoint to the migration wizard should be visible in about:preferences.", "type": "boolean", "setPref": {"branch": "user", "pref": "browser.migrate.preferences-entrypoint.enabled"}}, "aboutWelcomeBehavior": {"description": "When migration is kicked off from about:welcome, there are a few different behaviors that we want to test, controlled by a preference that is instrumented for Nimbus. The pref has the following possible states:\n\"autoclose\":\n  The user will be directed to the migration wizard in\n  about:preferences, but once the wizard is dismissed,\n  the tab will close.\n\n\"embedded\":\n  The migration wizard is embedded in about:welcome.\n\n\"standalone\":\n  The migration wizard will open in a new top-level content\n  window.\n\n\"default\" / other\n  The user will be directed to the migration wizard in\n  about:preferences. The tab will not close once the\n  user closes the wizard.", "type": "string", "setPref": {"branch": "user", "pref": "browser.migrate.content-modal.about-welcome-behavior"}}, "migrateExtensions": {"description": "True if importing extensions is enabled.", "type": "boolean", "setPref": {"branch": "user", "pref": "browser.migrate.chrome.extensions.enabled"}}, "chromeCanRequestPermissions": {"description": "True if Chrome-based browsers can request read permissions on platforms where the browser is restricted from reading the contents of a Chrome-based browser's user data directory. In practice, this is only relevant to the Linux platform when the browser is installed as a Snap package.", "type": "boolean", "setPref": {"branch": "user", "pref": "browser.migrate.chrome.get_permissions.enabled"}}}}, "mixedContentUpgrading": {"description": "Prefs to control whether we upgrade mixed passive content (images, audio, video) from http to https", "owner": "fbraun@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "True if the mixed content upgrading pref is enabled", "type": "boolean", "setPref": {"branch": "default", "pref": "security.mixed_content.upgrade_display_content"}}, "image": {"description": "True if the mixed content upgrading is enabled for images", "type": "boolean", "setPref": {"branch": "default", "pref": "security.mixed_content.upgrade_display_content.image"}}, "audio": {"description": "True if the mixed content upgrading is enabled for audio", "type": "boolean", "setPref": {"branch": "default", "pref": "security.mixed_content.upgrade_display_content.audio"}}, "video": {"description": "True if the mixed content upgrading is enabled for videos", "type": "boolean", "setPref": {"branch": "default", "pref": "security.mixed_content.upgrade_display_content.video"}}}}, "gc": {"description": "Prefs that control gc heuristics.", "owner": "dpalmeiro@mozilla.com", "hasExposure": false, "variables": {"max_nursery_size": {"description": "Set the maximum size of the GC nursery, in kb.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.nursery.max_kb"}}, "min_nursery_size": {"description": "Set the minimum size of the GC nursery, in kb.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.nursery.min_kb"}}, "gc_allocation_threshold_mb": {"description": "Lower limit for collecting a zone, in MB.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_allocation_threshold_mb"}}, "gc_balanced_heap_limits": {"description": "Whether balanced heap limits are enabled.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_balanced_heap_limits"}}, "gc_compacting": {"description": "Whether compacting GC is enabled.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_compacting"}}, "gc_generational": {"description": "Whether generational GC is enabled.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_generational"}}, "gc_heap_growth_factor": {"description": "Heap growth parameter for balanced heap limit calculation.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_heap_growth_factor"}}, "gc_helper_thread_ratio": {"description": "Number of threads to use for parallel GC work.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_helper_thread_ratio"}}, "gc_high_frequency_large_heap_growth": {"description": "Heap growth factor for large heaps in the high-frequency GC state.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_high_frequency_large_heap_growth"}}, "gc_high_frequency_small_heap_growth": {"description": "Heap growth factor for small heaps in the high-frequency GC state.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_high_frequency_small_heap_growth"}}, "gc_high_frequency_time_limit_ms": {"description": "GCs less than this far apart in milliseconds will be considered high-frequency GCs.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_high_frequency_time_limit_ms"}}, "gc_incremental": {"description": "Whether incremental GC is enabled. If not, GC will always run to completion.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_incremental"}}, "incremental_weakmap": {"description": "Enable incremental weakmap marking.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.mem.incremental_weakmap"}}, "gc_incremental_slice_ms": {"description": "Max milliseconds to spend in an incremental GC slice.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_incremental_slice_ms"}}, "gc_large_heap_incremental_limit": {"description": "Limit of how far over the incremental trigger threshold we allow the heap to grow before finishing a collection non-incrementally, for large heaps.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_large_heap_incremental_limit"}}, "gc_large_heap_size_min_mb": {"description": "Lower limit for classifying a heap as large, in MB.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_large_heap_size_min_mb"}}, "gc_low_frequency_heap_growth": {"description": "Heap growth factor for low frequency GCs.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_low_frequency_heap_growth"}}, "gc_malloc_threshold_base_mb": {"description": "Set the malloc threshold base value in MB.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_malloc_threshold_base_mb"}}, "gc_max_empty_chunk_count": {"description": "Do not keep more than this many unused chunks in the free chunk pool.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_max_empty_chunk_count"}}, "gc_max_helper_threads": {"description": "The maximum number of background threads to use for parallel GC work.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_max_helper_threads"}}, "gc_min_empty_chunk_count": {"description": "We try to keep at least this many unused chunks in the free chunk pool at all times, even after a shrinking GC.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_min_empty_chunk_count"}}, "gc_parallel_marking": {"description": "Enable parallel marking.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_parallel_marking"}}, "gc_parallel_marking_threshold_mb": {"description": "The heap size above which to use parallel marking.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_parallel_marking_threshold_mb"}}, "gc_max_parallel_marking_threads": {"description": "The maximum number of threads to use for parallel marking, if enabled.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_max_parallel_marking_threads"}}, "gc_per_zone": {"description": "Whether per-zone GC is enabled. If not, all zones are collected every time.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_per_zone"}}, "gc_small_heap_incremental_limit": {"description": "Limit of how far over the incremental trigger threshold we allow the heap to grow before finishing a collection non-incrementally, for small heaps.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_small_heap_incremental_limit"}}, "gc_small_heap_size_max_mb": {"description": "Upper limit for classifying a heap as small, in MB.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_small_heap_size_max_mb"}}, "gc_urgent_threshold_mb": {"description": "Set the urgent threshold, in MB.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.gc_urgent_threshold_mb"}}, "nursery_eager_collection_threshold_kb": {"description": "Set the eager collection threshold, in kb, for the nursery.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.nursery_eager_collection_threshold_kb"}}, "nursery_eager_collection_threshold_percent": {"description": "Set the eager collection percent threshold for the nursery.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.nursery_eager_collection_threshold_percent"}}, "nursery_eager_collection_timeout_ms": {"description": "Set the eager collection timeout, in ms, for the nursery.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.mem.nursery_eager_collection_timeout_ms"}}}}, "jsParallelParsing": {"description": "Pref to toggle JS parallel parsing.", "owner": "dpalmeiro@mozilla.com, nbp@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "True to enable parallel parsing.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.parallel_parsing"}}}}, "jitThresholds": {"description": "Prefs that control jit tier thresholds.", "owner": "dpalmeiro@mozilla.com, jdemooij@mozilla.com", "hasExposure": false, "variables": {"blinterp_threshold": {"description": "Set the threshold to enable blinterp compilation.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.blinterp.threshold"}}, "baseline_threshold": {"description": "Set the threshold to enable baseline compilation.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.baselinejit.threshold"}}, "ion_threshold": {"description": "Set the threshold to enable ion compilation.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.ion.threshold"}}, "ion_bailout_threshold": {"description": "Set the ion frequent bailout threshold.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.ion.frequent_bailout_threshold"}}, "ion_offthread_compilation": {"description": "True to enable offthread ion compilations.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.ion.offthread_compilation"}}, "inlining_max_length": {"description": "Set the max bytecode length considered for inlining.", "type": "int", "setPref": {"branch": "user", "pref": "javascript.options.inlining_bytecode_max_length"}}}}, "jitHintsCache": {"description": "Pref to toggle the JIT hints cache.", "owner": "dpalmeiro@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "True to enable the hints cache.", "type": "boolean", "setPref": {"branch": "user", "pref": "javascript.options.jithints"}}}}, "raceCacheWithNetwork": {"description": "Prefs to toggle the race cache with network.", "owner": "dpalmeiro@mozilla.com, acreskey@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "True to enable the rcwn feature.", "type": "boolean", "setPref": {"branch": "default", "pref": "network.http.rcwn.enabled"}}}}, "shopping2023": {"description": "Prefs to control the 2023 shopping experiment.", "owner": "jhirsch@mozilla.com", "hasExposure": true, "exposureDescription": "The timing of the exposure event depends on the experiment, but generally the event is recorded when the user first encounters onboarding UI for the shopping feature.", "variables": {"enabled": {"description": "True if the experience is enabled (experimental treatment group)", "type": "boolean", "fallbackPref": "browser.shopping.experience2023.enabled"}, "control": {"description": "True if the experiment is enabled but experience is disabled (experimental control group)", "type": "boolean", "fallbackPref": "browser.shopping.experience2023.control"}, "adsEnabled": {"description": "True if showing recommended products is enabled", "type": "boolean", "setPref": {"branch": "default", "pref": "browser.shopping.experience2023.ads.enabled"}}, "adsExposure": {"description": "True if we want to record ad inventory for opted-in users, even if ads are disabled", "type": "boolean", "setPref": {"branch": "default", "pref": "browser.shopping.experience2023.ads.exposure"}}, "surveyEnabled": {"description": "True if showing survey is enabled", "type": "boolean", "fallbackPref": "browser.shopping.experience2023.survey.enabled"}, "autoOpenEnabled": {"description": "True if auto-open behavior for the sidebar is enabled", "type": "boolean", "setPref": {"branch": "default", "pref": "browser.shopping.experience2023.autoOpen.enabled"}}}}, "shoppingOHTTP": {"description": "Prefs to control the OHTTP URLs used for shopping.", "owner": "gijs@mozilla.com", "hasExposure": false, "variables": {"ohttpRelayURL": {"description": "What OHTTP relay URL to use", "type": "string", "setPref": {"branch": "default", "pref": "toolkit.shopping.ohttpRelayURL"}}, "ohttpConfigURL": {"description": "URL for the OHTTP config to use", "type": "string", "setPref": {"branch": "default", "pref": "toolkit.shopping.ohttpConfigURL"}}}}, "opaqueResponseBlocking": {"description": "Prefs to enable Opaque Response Blocking", "owner": "farre@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent when a response is blocked", "variables": {"enabled": {"description": "Whether ORB is enabled", "type": "boolean", "setPref": {"branch": "user", "pref": "browser.opaqueResponseBlocking"}}, "javascriptValidator": {"description": "Whether JavaScript validation for ORB is enabled", "type": "boolean", "setPref": {"branch": "user", "pref": "browser.opaqueResponseBlocking.javascriptValidator"}}, "filterFetchResponse": {"description": "Whether filtering of internal responses in the parent ORB is enabled", "type": "int", "setPref": {"branch": "user", "pref": "browser.opaqueResponseBlocking.filterFetchResponse"}}, "mediaExceptionsStrategy": {"description": "If we partially or wholly allow audio and video MIME types in conflict with spec.", "type": "int", "setPref": {"branch": "user", "pref": "browser.opaqueResponseBlocking.mediaExceptionsStrategy"}}}}, "updatePrompt": {"description": "Prefs to control content and behavior of update notifications", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent at most once per browsing session when an update notification prompt is displayed.", "variables": {"showReleaseNotesLink": {"type": "boolean", "description": "If true, the \"Learn More\" link will be shown in the update prompt. If false or omitted, the link will only be shown for supported locales."}, "releaseNotesURL": {"type": "string", "fallbackPref": "app.releaseNotesURL.prompt", "description": "Template for the URL opened when the user clicks the \"Learn More\" link in the update prompt. If an empty string, the link will not be shown."}}}, "powerSaver": {"description": "Prefs to control power saving behaviors", "owner": "florian@mozilla.com", "hasExposure": false, "variables": {"reduceFrameRates": {"type": "int", "setPref": {"branch": "user", "pref": "gfx.display.max-frame-rate"}, "description": "Limit the number of frames displayed per second. If omitted, the refresh rate of the screen will be used."}, "mediaAutoPlay": {"type": "int", "setPref": {"branch": "user", "pref": "media.autoplay.default"}, "description": "Control if media is allowed to auto-play, with and without sound."}, "backgroundTimerMinTime": {"type": "int", "setPref": {"branch": "user", "pref": "dom.min_background_timeout_value"}, "description": "Limit how frequently timers are allowed to run in background tabs."}, "backgroundTimerRegenerationRate": {"type": "int", "setPref": {"branch": "user", "pref": "dom.timeout.background_budget_regeneration_rate"}, "description": "Limit how quickly the background tab timer budget regenerates."}}}, "backgroundUpdate": {"description": "Prefs to control aspects of the background update process.", "owner": "install-update@mozilla.com", "hasExposure": true, "exposureDescription": "The exposure event is sent when scheduling the background task and both the feature is enabled and the service registry key (Mozilla Maintenance Service) is *not* available for this installation. That is the first time the feature can impact Firefox behaviour and the user experience.", "variables": {"enableUpdatesForUnelevatedInstallations": {"description": "Allow the background update process to download and apply updates when the Mozilla Maintenance Service is unavailable but the installation directory can be written.", "type": "boolean", "setPref": {"branch": "user", "pref": "app.update.background.allowUpdatesForUnelevatedInstallations"}}}}, "bookmarks": {"description": "Prefs to control aspects of the bookmarks system.", "owner": "omc@mozilla.com", "hasExposure": false, "variables": {"enableBookmarksToolbar": {"type": "string", "setPref": {"branch": "user", "pref": "browser.toolbars.bookmarks.visibility"}, "description": "If the bookmarks toolbar should never, always, or only show on newtab."}, "showOtherBookmarks": {"type": "boolean", "setPref": {"branch": "user", "pref": "browser.toolbars.bookmarks.showOtherBookmarks"}, "description": "Display state of the \"Other Bookmarks\" toolbar button."}}}, "cookieBannerHandling": {"description": "Automatically handle cookie banners on the user's behalf.", "owner": "emz@mozilla.com", "hasExposure": false, "variables": {"modeNormalBrowsing": {"type": "int", "setPref": {"branch": "default", "pref": "cookiebanners.service.mode"}, "description": "Controls the cookie banner handling mode in normal browsing. Values: 0 - disabled, 1 - reject all, 2 - reject all with accept all fallback."}, "modePrivateBrowsing": {"type": "int", "setPref": {"branch": "default", "pref": "cookiebanners.service.mode.privateBrowsing"}, "description": "Controls the cookie banner handling mode in private browsing. Values: 0 - disabled, 1 - reject all, 2 - reject all with accept all fallback."}, "enableGlobalRules": {"type": "boolean", "setPref": {"branch": "default", "pref": "cookiebanners.service.enableGlobalRules"}, "description": "Enables use of global CookieBannerRules, which apply to all sites. This enables handling of CMPs across sites without the use of site-specific rules."}, "enableGlobalRulesSubFrames": {"type": "boolean", "setPref": {"branch": "default", "pref": "cookiebanners.service.enableGlobalRules.subFrames"}, "description": "Whether global rules are allowed to run in sub-frames. Running query selectors in every sub-frame may negatively impact performance, but is required for some CMPs."}, "enableDetectOnly": {"type": "boolean", "setPref": {"branch": "default", "pref": "cookiebanners.service.detectOnly"}, "description": "When set to true, cookie banners are detected and detection events are dispatched, but they will not be handled. This pref applies to both normal and private browsing windows."}, "enableFirefoxDesktopUI": {"type": "boolean", "setPref": {"branch": "default", "pref": "cookiebanners.ui.desktop.enabled"}, "description": "Enables the cookie banner desktop UI."}, "enablePromo": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.promo.cookiebanners.enabled"}, "description": "Enables the cookie banner promo in about:privatebrowsing."}, "enableDesktopFeatureCallout": {"type": "boolean", "setPref": {"branch": "default", "pref": "cookiebanners.ui.desktop.showCallout"}, "description": "Enables the cookie banner feature callout on desktop."}}}, "backgroundThreads": {"description": "Prefs to control MacOS thread priorities for power savings.", "owner": "kwright@mozilla.com", "hasExposure": false, "variables": {"use_low_power": {"description": "Use the MacOS QoS libraries to deprioritize select threads.", "type": "boolean", "setPref": {"branch": "user", "pref": "threads.use_low_power.enabled"}}, "lower_mainthread_priority_in_background": {"description": "When a browsing context is put in the background and isn't actively playing media, deprioritize its main thread.", "type": "boolean", "setPref": {"branch": "user", "pref": "threads.lower_mainthread_priority_in_background.enabled"}}}}, "reportBrokenSite": {"description": "The Report Broken Site feature", "owner": "twisniewski@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "boolean", "setPref": {"branch": "user", "pref": "ui.new-webcompat-reporter.enabled"}, "description": "Whether Report Broken Site is enabled"}, "sendMoreInfo": {"type": "boolean", "setPref": {"branch": "user", "pref": "ui.new-webcompat-reporter.send-more-info-link"}, "description": "Whether Report Broken Site shows the send more info link directing users to webcompat.com (defaults to true for prerelease channels)"}, "reasonDropdown": {"type": "int", "setPref": {"branch": "user", "pref": "ui.new-webcompat-reporter.reason-dropdown"}, "description": "0 = do not show the \"reason\" dropdown 1 = show an optional \"reason\" dropdown 2 = show a required \"reason\" dropdown"}}}, "feltPrivacy": {"description": "Prefs for Felt Privacy v1 experiments", "owner": "cmeador@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure when user opens a private browsing window.", "variables": {"feltPrivacy": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.privatebrowsing.felt-privacy-v1"}, "description": "When true, new styles and copy enabled on about:privatebrowsing. When true, a toggle for showing or hiding quick suggestions appears in about:preferences."}, "resetPBMAction": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.privatebrowsing.resetPBM.enabled"}, "description": "Enables the reset PBM feature button and confirmation panel."}}}, "phc": {"description": "Prefs to control the Probabalistic Heap Checker (PHC)", "owner": "pbone@mozilla.com", "hasExposure": false, "variables": {"phcEnabled": {"description": "Whether to enable PHC", "type": "boolean", "setPref": {"branch": "user", "pref": "memory.phc.enabled"}}, "phcMinRamMB": {"description": "The minimum amount of RAM required to enable PHC", "type": "int", "setPref": {"branch": "user", "pref": "memory.phc.min_ram_mb"}}, "phcAvgDelayFirst": {"description": "The delay before the first PHC allocation", "type": "int", "setPref": {"branch": "user", "pref": "memory.phc.avg_delay.first"}}, "phcAvgDelayNormal": {"description": "The delay between PHC allocations", "type": "int", "setPref": {"branch": "user", "pref": "memory.phc.avg_delay.normal"}}, "phcAvgDelayPageReuse": {"description": "The delay before reusing a PHC page", "type": "int", "setPref": {"branch": "user", "pref": "memory.phc.avg_delay.page_reuse"}}}}, "mailto": {"description": "Prefs to control aspects of the mailto handler", "owner": "install-update@mozilla.com", "hasExposure": true, "exposureDescription": "The exposure event is sent when a webmail site calls the registerProtocolHandler function and when users use mailto links in Firefox.", "variables": {"dualPrompt": {"type": "boolean", "description": "Can be used to toggle the entire feature on and off.", "fallbackPref": "browser.mailto.dualPrompt"}, "dualPrompt.onLocationChange": {"type": "boolean", "description": "Display a reminder prompt for known webmailers if the prompt was not dismissed before the next visit of that webmailer.", "fallbackPref": "browser.mailto.dualPrompt.onLocationChange"}, "dualPrompt.dismissXClickMinutes": {"type": "int", "description": "This pref controls after how many minutes the mailto prompt can be shown again, which has been dismissed by clicking the 'X' button before.", "fallbackPref": "browser.mailto.dualPrompt.dismissXClickMinutes"}, "dualPrompt.dismissNotNowMinutes": {"type": "int", "description": "This pref controls after how many minutes the mailto prompt can be shown again, which has been dismissed by clicking a 'not now' button on it.", "fallbackPref": "browser.mailto.dualPrompt.dismissNotNowMinutes"}}}, "nimbusIsReady": {"description": "A feature that provides the number of Nimbus is_ready events to send when Nimbus is ready.", "owner": "chumphreys@mozilla.com", "hasExposure": false, "applications": ["firefox-desktop"], "variables": {"eventCount": {"description": "The number of events that should be sent.", "type": "int"}}}, "nimbusTelemetry": {"description": "A feature that enables or disables Nimbus telemetry.", "owner": "nimbus-team@mozilla.com", "hasExposure": false, "applications": ["firefox-desktop"], "variables": {"gleanMetricConfiguration": {"description": "A Glean metric configuration JSON blob.\nThis is limited to configuring the following categories: - nimbus_events - nimbus_targeting_context - nimbus_targeting_environment\n", "type": "json"}, "nimbusTargetingEnvironment": {"description": "Configuration for the nimbus_targeting_environment telemetry category.\n", "type": "json"}}, "schema": {"uri": "resource://nimbus/schemas/NimbusTelemetryFeature.schema.json", "path": "toolkit/components/nimbus/schemas/NimbusTelemetryFeature.schema.json"}}, "httpsFirst": {"description": "Prefs for HTTPS-First, which upgrades all top-level page loads to HTTPS and provides a automatic fallback to HTTP if the site isn't available via HTTPS.", "owner": "mjurgens@mozilla.com, seceng-telemetry@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "Enable HTTPS-First", "type": "boolean", "setPref": {"branch": "default", "pref": "dom.security.https_first"}}, "enabledPbm": {"description": "Enable HTTPS-First in private browsing only", "type": "boolean", "setPref": {"branch": "default", "pref": "dom.security.https_first_pbm"}}, "enabledSchemeless": {"description": "Enables schemeless HTTPS-First, which will only apply HTTPS-First to address bar inputs without a scheme. This essentially makes HTTPS the default scheme in the address bar, while providing a fallback to HTTP.", "type": "boolean", "setPref": {"branch": "default", "pref": "dom.security.https_first_schemeless"}}, "backgroundTimerMs": {"description": "After a request gets upgraded to HTTPS, specifies the time after which a second HTTP request is fired to check if the site is available via HTTPS, but timing out via HTTPS. This also applies to HTTPS-Only, not just HTTPS-First.", "type": "int", "setPref": {"branch": "default", "pref": "dom.security.https_only_fire_http_request_background_timer_ms"}}}}, "contentRelevancy": {"description": "A feature for interest-based content relevance ranking and personalization for Firefox.", "owner": "disco-team@mozilla.com", "hasExposure": false, "variables": {"enabled": {"description": "Enable this feature", "type": "boolean", "fallbackPref": "toolkit.contentRelevancy.enabled"}, "maxInputUrls": {"description": "The maximum number of input URLs for interest classification", "type": "int"}, "minInputUrls": {"description": "The minimal number of input URLs for interest classification", "type": "int"}, "timerInterval": {"description": "The interval (in seconds) of the background update timer for the content relevancy manager", "type": "int", "setPref": {"branch": "user", "pref": "toolkit.contentRelevancy.timerInterval"}}, "ingestEnabled": {"description": "Enable the ingestion through the Rust component", "type": "boolean", "fallbackPref": "toolkit.contentRelevancy.ingestEnabled"}}}, "backupService": {"description": "Prefs to control the profile backup service", "owner": "mconley@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.backup.enabled"}, "description": "When true, the profile backup service will be initialized soon after startup."}, "prefsUIEnabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "browser.backup.preferences.ui.enabled"}, "description": "When true, the section in about:preferences to control the backup feature is visible."}, "sqlitePagesPerStep": {"description": "The number of database pages to backup per step when backing up an SQLite database.", "type": "int", "setPref": {"branch": "user", "pref": "browser.backup.sqlite.pages_per_step"}}, "sqliteStepDelayMs": {"description": "The delay between SQLite database backup steps in milliseconds.", "type": "int", "setPref": {"branch": "user", "pref": "browser.backup.sqlite.step_delay_ms"}}, "idleThresholdSeconds": {"description": "The number of seconds of user idle time to wait for before considering to schedule a backup.", "type": "int", "setPref": {"branch": "user", "pref": "browser.backup.scheduled.idle-threshold-seconds"}}, "minTimeBetweenBackupsSeconds": {"description": "The minimum number of seconds since the last known backup that must pass before we might schedule a backup.", "type": "int", "setPref": {"branch": "user", "pref": "browser.backup.scheduled.minimum-time-between-backups-seconds"}}}}, "pqcrypto": {"description": "Prefs that control the use of post-quantum cryptography.", "owner": "jschanck@mozilla.com", "hasExposure": false, "variables": {"tlsEnableMlkem": {"type": "boolean", "setPref": {"branch": "default", "pref": "security.tls.enable_kyber"}, "description": "Whether to enable mlkem768x25519 for TLS."}, "h3EnableMlkem": {"type": "boolean", "setPref": {"branch": "default", "pref": "network.http.http3.enable_kyber"}, "description": "Whether to enable mlkem768x25519 for H3/QUIC."}, "sendP256": {"type": "boolean", "setPref": {"branch": "default", "pref": "security.tls.client_hello.send_p256_keyshare"}, "description": "Whether to send a P256 share in the client hello in QUIC and TLS."}, "dtlsWebRTCEnableMlkem": {"type": "boolean", "setPref": {"branch": "default", "pref": "media.webrtc.enable_pq_dtls"}, "description": "Whether to enable mlkem768x25519 for DTLS in WebRTC."}}}, "dtlsWebRTC": {"description": "Pref that controls the use of DTLS.", "owner": "nkulatova@mozilla.com", "hasExposure": false, "variables": {"tlsVersionDTLS": {"type": "int", "setPref": {"branch": "default", "pref": "media.peerconnection.dtls.version.max"}, "description": "The maximum version of DTLS protocol used in WebRTC (770 = DTLS 1.0, 771 = DTLS 1.2, 772 = DTLS 1.3)."}}}, "certCompression": {"description": "Prefs that control the use of certificate compression decoders.", "owner": "anna.weine@mozilla.com", "hasExposure": false, "variables": {"tlsEnableZlib": {"type": "boolean", "setPref": {"branch": "default", "pref": "security.tls.enable_certificate_compression_zlib"}, "description": "Whether to enable Zlib for TLS certificate compression."}, "tlsEnableBrotli": {"type": "boolean", "setPref": {"branch": "default", "pref": "security.tls.enable_certificate_compression_brotli"}, "description": "Whether to enable Brotli for TLS certificate compression."}, "tlsEnableZstd": {"type": "boolean", "setPref": {"branch": "default", "pref": "security.tls.enable_certificate_compression_zstd"}, "description": "Whether to enable Zstd for TLS certificate compression."}}}, "bounceTrackingProtection": {"description": "Controls the Bounce Tracking Protection feature.", "owner": "emz@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "int", "setPref": {"branch": "default", "pref": "privacy.bounceTrackingProtection.mode"}, "description": "Mode to run the feature in. See nsIBounceTrackingProtection.idl for documentation."}}}, "remoteTabManagement": {"description": "Features that let users manage tabs on other devices that are connected to the same Mozilla account.\n", "owner": "skhamis@mozilla.com", "hasExposure": false, "variables": {"closeTabsEnabled": {"description": "When true, the user can close tabs on other devices connected to the same Mozilla account from the synced tabs menu.", "type": "boolean", "fallbackPref": "identity.fxaccounts.commands.remoteTabManagement.enabled"}}}, "crlite": {"description": "Prefs that control the use of CRLite", "owner": "jschanck@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "security.remote_settings.crlite_filters.enabled"}, "description": "Whether CRLite artifacts will be downloaded."}, "channel": {"type": "string", "setPref": {"branch": "default", "pref": "security.pki.crlite_channel"}, "description": "The channel from which CRLite artifacts will be downloaded."}, "mode": {"type": "int", "setPref": {"branch": "default", "pref": "security.pki.crlite_mode"}, "description": "How CRLite results will be interpreted."}, "timestamps_for_coverage": {"type": "int", "setPref": {"branch": "default", "pref": "security.pki.crlite_timestamps_for_coverage"}, "description": "How many covered timestamps do we need to see before we enforce a CRLite result."}}}, "chatbot": {"description": "AI chatbot feature configuration", "owner": "elee@mozilla.com", "hasExposure": false, "variables": {"minVersion": {"type": "string", "description": "Minimum Firefox version to apply prefs"}, "prefs": {"type": "json", "description": "The prefs to set under browser.ml.chat.* with object keys as the sub-pref and values objects indicating the desired branch and value defaulting to clearing the user branch value."}}}, "sidebar": {"description": "Sidebar feature configuration", "owner": "elee@mozilla.com", "hasExposure": false, "variables": {"minVersion": {"type": "string", "description": "Minimum Firefox version to apply prefs"}, "main.tools": {"type": "string", "description": "sidebar.main.tools pref value to set on user branch; which tools for sidebar panels show in the launcher"}, "revamp": {"type": "boolean", "description": "sidebar.revamp pref value to set on user branch; true for new experience"}, "verticalTabs": {"type": "boolean", "description": "sidebar.verticalTabs pref value to set on user branch; true to enable vertical tabs"}, "visibility": {"type": "string", "description": "sidebar.visibility pref value (\"hide\" or \"always-show\") to set on user branch"}}}, "fxms_bmb_button": {"description": "A feature for the Firefox Messaging System Bookmarks Bar button surface", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.", "schema": {"uri": "chrome://browser/content/asrouter/schemas/MessagingExperiment.schema.json", "path": "browser/components/asrouter/content-src/schemas/MessagingExperiment.schema.json"}, "variables": {}}, "contentProcessSandbox": {"description": "Prefs that control the content process sandbox.", "owner": "bowen@mozilla.com", "hasExposure": false, "variables": {"Level": {"description": "Content process sandbox level", "type": "int", "setPref": {"branch": "user", "pref": "security.sandbox.content.level"}}}}, "certificateTransparency": {"description": "Certificate Transparency configuration", "owner": "dkeeler@mozilla.com", "hasExposure": false, "variables": {"mode": {"type": "int", "setPref": {"branch": "default", "pref": "security.pki.certificate_transparency.mode"}, "description": "What mode Certificate Transparency is in (0=disable, 1=telemetry only, 2=enforce)."}}}, "setToDefaultPrompt": {"description": "Experimental set to default spotlight", "owner": "omc@mozilla.com", "hasExposure": true, "exposureDescription": "\"Exposure is sent if the message is about to be shown after trigger and targeting conditions on the message matched.\"", "variables": {"showSpotlightPrompt": {"description": "Show experimental set to default spotlight message instead of default prompt", "type": "boolean"}, "message": {"description": "Message to show instead of the default prompt", "type": "json"}}}, "tabGroups": {"description": "Prefs to control Tab Groups", "owner": "dao@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "boolean", "fallbackPref": "browser.tabs.groups.enabled", "description": "Controls whether users can create new tab groups via drag and drop or the tab context menu"}}}, "smartblockEmbeds": {"description": "Pref to control Smartblock Embeds", "owner": "emz@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "boolean", "setPref": {"branch": "default", "pref": "extensions.webcompat.smartblockEmbeds.enabled"}, "description": "Controls whether smartblock embed placeholders and protections panel toggles will be shown to the user."}}}, "selectableProfiles": {"description": "Multiple profile management using selectableProfileService", "owner": "jhirsch@mozilla.com", "hasExposure": false, "variables": {"enabled": {"type": "boolean", "description": "Enables the multiple profiles feature when true. Turning off this variable will not disable the feature."}}}};